package com.elitesland.scp.domain.service.purLimit;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingStoreSaveVO;

import java.util.List;

public interface ScpPurLimitSettingStoreDomainService {

    /**
     * 订货强配活动门店查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpPurLimitSettingStoreRespVO> page(ScpPurLimitSettingStorePageParamVO paramVO);

    /**
     * 订货强配活动门店保存
     *
     * @param saveVOS 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    void batchSavePurLimitSettingStore(List<ScpPurLimitSettingStoreSaveVO> saveVOS, int batchSize);

    default void batchSavePurLimitSettingStore(List<ScpPurLimitSettingStoreSaveVO> saveVOS) {
        batchSavePurLimitSettingStore(saveVOS, 100);
    }

    /**
     * 删除订货强配活动门店
     *
     * @param masId
     */
    void deleteByMasId(Long masId);

    /**
     * 删除订货强配活动门店
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 根据门店查询
     *
     * @param storeCode
     * @return
     */
    List<Long> findMasIdByStoreCode(String storeCode);

    /**
     * 更新已强配次数
     *
     * @param masIds
     * @param storeCode
     */
    void updatePurLimitNumByParam(List<Long> masIds, String storeCode);

    /**
     * 根据参数查询
     * @param paramVO
     */
    List<ScpPurLimitSettingStoreRespVO> findByParam(ScpPurLimitSettingStoreParamVO paramVO);

    /**
     * 更新门店
     * @param saveVO
     */
    Long updatePurLimitSettingStore(ScpPurLimitSettingStoreSaveVO saveVO);

    /**
     * 根据活动ID查询门店
     * @param masId
     * @return
     */
    List<ScpPurLimitSettingStoreRespVO> findByMasId(Long masId);

    List<ScpPurLimitSettingStoreRespVO> findEnabledByParam(ScpPurLimitSettingStoreParamVO paramVO);
}
