package com.elitesland.scp.infr.repo.mrp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpRespVO;
import com.elitesland.scp.domain.entity.mrp.QScpMrpDDO;
import com.elitesland.scp.domain.entity.mrp.QScpMrpDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpMrpRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpMrpDO scpMrpDO = QScpMrpDO.scpMrpDO;
    private final QScpMrpDDO scpMrpDDO = QScpMrpDDO.scpMrpDDO;

    private final QBean<ScpMrpRespVO> baseBean = Projections.bean(
            ScpMrpRespVO.class,
            scpMrpDO.id,
            scpMrpDO.mrpLotNo,
            scpMrpDO.predLotNo,
            scpMrpDO.calcStatus,
            scpMrpDO.pushStatus,
            scpMrpDO.calcFailReason,
            scpMrpDO.pushFailReason,
            scpMrpDO.creator,
            scpMrpDO.createUserId,
            scpMrpDO.createTime,
            scpMrpDO.updater,
            scpMrpDO.modifyUserId,
            scpMrpDO.modifyTime,
            scpMrpDO.remark
    );

    public PagingVO<ScpMrpRespVO> pageQuery(ScpMrpPageParam param) {
        if (param == null) {
            return PagingVO.<ScpMrpRespVO>builder().total(0).records(null).build();
        }
        var jpaQuery = jpaQueryFactory.select(baseBean)
                .from(scpMrpDO);

        jpaQuery.where(this.where(param));
        if (CollectionUtil.isNotEmpty(param.getOuIds())
                || CollectionUtil.isNotEmpty(param.getWhIds())
                || CollectionUtil.isNotEmpty(param.getItemIds())) {
            var subQuery = getSubQuery(scpMrpDO.id.eq(scpMrpDDO.masId), param);
            jpaQuery.where(subQuery.exists());
        }

        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery, scpMrpDO);
        return PagingVO.<ScpMrpRespVO>builder()
                .total(pageCount(param))
                .records(jpaQuery.fetch())
                .build();
    }

    public Long pageCount(ScpMrpPageParam param) {
        var jpaQuery = jpaQueryFactory.select(scpMrpDO.count())
                .from(scpMrpDO);
        if (param != null) {
            jpaQuery.where(this.where(param));
            if (CollectionUtil.isNotEmpty(param.getOuIds())
                    || CollectionUtil.isNotEmpty(param.getWhIds())
                    || CollectionUtil.isNotEmpty(param.getItemIds())) {
                var subQuery = getSubQuery(scpMrpDO.id.eq(scpMrpDDO.masId), param);
                jpaQuery.where(subQuery.exists());
            }
        }

        return jpaQuery.fetchCount();
    }

    private JPQLQuery<Integer> getSubQuery(BooleanExpression id, ScpMrpPageParam param) {
        var subQuery = JPAExpressions.selectOne().from(scpMrpDDO)
                .where(id);
        if (CollectionUtil.isNotEmpty(param.getOuIds())) {
            subQuery.where(scpMrpDDO.ouId.in(param.getOuIds()));
        }
        if (CollectionUtil.isNotEmpty(param.getWhIds())) {
            subQuery.where(scpMrpDDO.whId.in(param.getWhIds()));
        }
        if (CollectionUtil.isNotEmpty(param.getItemIds())) {
            subQuery.where(scpMrpDDO.itemId.in(param.getItemIds()));
        }
        return subQuery;
    }

    private Predicate where(ScpMrpPageParam param) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(param.getMrpLotNo())) {
            predicates.add(scpMrpDO.mrpLotNo.like(param.getMrpLotNo() + "%"));
        }
        if (StrUtil.isNotBlank(param.getPredLotNo())) {
            predicates.add(scpMrpDO.mrpLotNo.like(param.getPredLotNo() + "%"));
        }
        if (StrUtil.isNotBlank(param.getCalcStatus())) {
            predicates.add(scpMrpDO.calcStatus.eq(param.getCalcStatus()));
        }
        if (StrUtil.isNotBlank(param.getPushStatus())) {
            predicates.add(scpMrpDO.pushStatus.eq(param.getPushStatus()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void updatePushStatus(List<Long> ids, String pushStatus, String pushFailReason) {
        JPAUpdateClause updateClause = jpaQueryFactory.update(scpMrpDO)
                .set(scpMrpDO.pushStatus, pushStatus)
                .where(scpMrpDO.id.in(ids));
        if (StrUtil.isNotBlank(pushFailReason)) {
            updateClause.set(scpMrpDO.pushFailReason, pushFailReason);
        } else {
            updateClause.setNull(scpMrpDO.pushFailReason);
        }
        updateClause.execute();
    }

    public void updateCalcStatus(List<Long> ids, String calcStatus, String calcFailReason) {
        JPAUpdateClause updateClause = jpaQueryFactory.update(scpMrpDO)
                .set(scpMrpDO.calcStatus, calcStatus)
                .where(scpMrpDO.id.in(ids));
        if (StrUtil.isNotBlank(calcFailReason)) {
            updateClause.set(scpMrpDO.calcFailReason, calcFailReason);
        } else {
            updateClause.setNull(scpMrpDO.calcFailReason);
        }
        updateClause.execute();
    }
}
