package com.elitesland.scp.infr.repo.purLimit;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingPageRespVO;
import com.elitesland.scp.domain.entity.purLimit.QScpPurLimitSettingDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpPurLimitSettingRepoProc {
    private static final QScpPurLimitSettingDO scpPurLimitSettingDO = QScpPurLimitSettingDO.scpPurLimitSettingDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final QBean<ScpPurLimitSettingPageRespVO> pageList = Projections.bean(
            ScpPurLimitSettingPageRespVO.class,
            scpPurLimitSettingDO.id,
            scpPurLimitSettingDO.docType,
            scpPurLimitSettingDO.activityCode,
            scpPurLimitSettingDO.activityName,
            scpPurLimitSettingDO.activityType,
            scpPurLimitSettingDO.validFrom,
            scpPurLimitSettingDO.validTo,
            scpPurLimitSettingDO.status,
            scpPurLimitSettingDO.creator,
            scpPurLimitSettingDO.createUserId,
            scpPurLimitSettingDO.createTime,
            scpPurLimitSettingDO.updater,
            scpPurLimitSettingDO.modifyUserId,
            scpPurLimitSettingDO.modifyTime,
            scpPurLimitSettingDO.remark
    );

    public long countPurLimitSetting(ScpPurLimitSettingPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpPurLimitSettingDO.count())
                .from(scpPurLimitSettingDO);
        jpaQuery.where(this.wherePurLimitSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpPurLimitSettingPageRespVO> queryPurLimitSetting(ScpPurLimitSettingPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpPurLimitSettingDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpPurLimitSettingDO);
        jpaQuery.where(this.wherePurLimitSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate wherePurLimitSettingPage(ScpPurLimitSettingPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpPurLimitSettingDO.docType.eq(paramVO.getDocType()));
        }
        if (paramVO.getValidFrom() != null && paramVO.getValidTo() != null) {
            predicates.add(scpPurLimitSettingDO.validFrom.loe(paramVO.getValidFrom()).and(scpPurLimitSettingDO.validTo.goe(paramVO.getValidTo())));
        }
        if (paramVO.getStatus() != null) {
            predicates.add(scpPurLimitSettingDO.status.eq(paramVO.getStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getActivityCodeName())) {
            predicates.add(scpPurLimitSettingDO.activityCode.like("%" + paramVO.getActivityCodeName() + "%").or(scpPurLimitSettingDO.activityName.like("%" + paramVO.getActivityCodeName() + "%")));
        }
        if (CollUtil.isNotEmpty(paramVO.getIds())) {
            predicates.add(scpPurLimitSettingDO.id.in(paramVO.getIds()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void enablePurLimitSetting(List<Long> ids, Boolean enable) {
        JPAUpdateClause update = jpaQueryFactory.update(scpPurLimitSettingDO)
                .set(scpPurLimitSettingDO.status, enable)
                .where(scpPurLimitSettingDO.id.in(ids));
        update.execute();
    }

    public long deleteByIds(List<Long> ids) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpPurLimitSettingDO.id.in(ids));
        var delete = jpaQueryFactory.delete(scpPurLimitSettingDO)
                .where(ExpressionUtils.allOf(predicates));
        return delete.execute();
    }

}
