package com.elitesland.scp.infr.repo.survey;

import com.elitesland.scp.domain.entity.survey.SurveyDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @auther JinXK
 * @date 2021/6/12 11:25
 */
public interface SurveyRepo extends JpaRepository<SurveyDO, Long>, QuerydslPredicateExecutor<SurveyDO> {


    void deleteByIdIn(List<Long> idList);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update scp_survey set fill_count = fill_count + 1, modify_time = now() where id = ?1", nativeQuery = true)
    void updateFillCountById(Long id);

}
