package com.elitesland.scp.infr.repo.wqf;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyPageParam;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountPageParam;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountPageVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountRespVO;
import com.elitesland.scp.domain.entity.wqf.QScpWqfEntAccountDO;
import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountDO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotNull;
import java.util.List;

@Component
public class ScpWqfEntAccountRepoProc extends BaseRepoProc<ScpWqfEntAccountDO> {

    private static final QScpWqfEntAccountDO scpWqfEntAccountDO = QScpWqfEntAccountDO.scpWqfEntAccountDO;

    public ScpWqfEntAccountRepoProc(){
        super(scpWqfEntAccountDO);
    }


    public ScpWqfEntAccountRespVO getEntAcctIdByStoreIdAndEntId(String storeCode, String entId) {
        return jpaQueryFactory.select(Projections.bean(ScpWqfEntAccountRespVO.class,
                        scpWqfEntAccountDO.entAcctId,
                        scpWqfEntAccountDO.bankAccount
                )).distinct()
                .from(scpWqfEntAccountDO)
                .where(scpWqfEntAccountDO.storeCode.eq(storeCode).and(scpWqfEntAccountDO.entId.eq(entId))
                        .and(scpWqfEntAccountDO.status.eq(Boolean.TRUE)))
                .fetchOne();
    }

    public PagingVO<ScpWqfEntAccountPageVO> page(ScpWqfEntAccountPageParam param){
        JPAQuery<ScpWqfEntAccountPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                    ScpWqfEntAccountPageVO.class,
                    scpWqfEntAccountDO.id,
                    scpWqfEntAccountDO.remark,
                    scpWqfEntAccountDO.createUserId,
                    scpWqfEntAccountDO.creator,
                    scpWqfEntAccountDO.createTime,
                    scpWqfEntAccountDO.modifyUserId,
                    scpWqfEntAccountDO.updater,
                    scpWqfEntAccountDO.modifyTime,
                    scpWqfEntAccountDO.ouId,
                    scpWqfEntAccountDO.ouCode,
                    scpWqfEntAccountDO.entId,
                    scpWqfEntAccountDO.storeId,
                    scpWqfEntAccountDO.storeCode,
                    scpWqfEntAccountDO.entAcctId,
                    scpWqfEntAccountDO.accountType,
                    scpWqfEntAccountDO.bankAccount,
                    scpWqfEntAccountDO.openBank,
                    scpWqfEntAccountDO.bankBranchCode,
                    scpWqfEntAccountDO.branchName,
                    scpWqfEntAccountDO.status,
                    scpWqfEntAccountDO.applyNo
                )).from(scpWqfEntAccountDO);
        jpaQuery.where(where(param));
        return queryByPage(jpaQuery,param.getPageRequest());
    }

    private Predicate where(ScpWqfEntAccountPageParam param){
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if(CollectionUtils.isNotEmpty(param.getOuIds())){
            predicate = ExpressionUtils.and(predicate, scpWqfEntAccountDO.ouId.in(param.getOuIds()));
        }
        if(CollectionUtils.isNotEmpty(param.getStoreIds())){
            predicate = ExpressionUtils.and(predicate, scpWqfEntAccountDO.storeId.in(param.getStoreIds()));
        }
        if(StringUtils.isNotEmpty(param.getEntId())){
            predicate = ExpressionUtils.and(predicate, scpWqfEntAccountDO.entId.like("%"+param.getEntId()+"%"));
        }
        if(StringUtils.isNotEmpty(param.getEntAcctId())){
            predicate = ExpressionUtils.and(predicate, scpWqfEntAccountDO.entAcctId.like("%"+param.getEntAcctId()+"%"));
        }
        if(CollectionUtils.isNotEmpty(param.getAccountTypes())){
            predicate = ExpressionUtils.and(predicate, scpWqfEntAccountDO.accountType.in(param.getAccountTypes()));
        }
        if(param.getStatus() != null){
            predicate = ExpressionUtils.and(predicate, scpWqfEntAccountDO.status.eq(param.getStatus()));
        }
        return predicate;
    }

    public List<ScpWqfEntAccountDO> findByApplyNo(String applyNo) {
        return jpaQueryFactory.selectFrom(scpWqfEntAccountDO)
                .where(scpWqfEntAccountDO.applyNo.eq(applyNo))
                .fetch();
    }

}
