package com.elitesland.scp.job.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.domain.vo.survey.SurveyPagingParam;
import com.elitesland.scp.domain.vo.survey.SurveyRespVO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.survey.SurveyRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpSurveyInvalidJobServiceImpl implements ScpSurveyInvalidJobService {

    private final SurveyRepoProc surveyRepoProc;

    @Override
    public void autoInvalid() {
        // 查询在结束时间已过期，且状态不是失效的问卷
        SurveyPagingParam pagingParam = new SurveyPagingParam();
        pagingParam.setSize(10000);
        pagingParam.setNotSurveyStatus(ScpUdcEnum.SURVEY_STATUS_40.getValueCode());
        pagingParam.setNeedFilterInvalidTime("Y");
        PagingVO<SurveyRespVO> search = surveyRepoProc.search(pagingParam);
        if(CollectionUtils.isNotEmpty(search.getRecords())){
            List<Long> suvIdList = search.getRecords().stream().map(SurveyRespVO::getId).toList();
            surveyRepoProc.invalid(suvIdList);
        }
    }

}
