/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthoritySaveVO;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityService;
import com.elitesland.scp.domain.convert.StoreInfoConvert;
import com.elitesland.scp.domain.convert.authority.ScpDemandAuthorityConvert;
import com.elitesland.scp.dto.authority.ItemObject;
import com.elitesland.scp.dto.authority.ScpManAuthorityRpcSaveVO;
import com.elitesland.scp.dto.authority.StoreAuthorityRespDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcPageDTO;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.service.authority.StoreAuthorityRpcService;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StoreAuthorityRpcServiceImpl
implements StoreAuthorityRpcService {
    private static final Logger log = LoggerFactory.getLogger(StoreAuthorityRpcServiceImpl.class);
    private final RmiOrgStoreRpcService rmiOrgStoreService;
    private final RmiItemService rmiItemService;
    private final ScpsmanAuthorityService scpsmanAuthorityService;
    @Value(value="${ext.server-addr}")
    private String serverAddr;

    @SysCodeProc
    public ApiResult<PagingVO<ItemObject>> getStoreAuthorityDataPage(StoreAuthorityRpcPageDTO storeAuthorityRpcPageDTO) {
        log.info("\u95e8\u5e97\u8981\u8d27\u6743\u9650\u6570\u636e\u5206\u9875\u83b7\u53d6\uff0c\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)storeAuthorityRpcPageDTO));
        String storeCode = storeAuthorityRpcPageDTO.getStoreCode();
        if (StrUtil.isBlank((CharSequence)storeCode)) {
            throw new BusinessException("\u53c2\u6570\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrgStoreBaseRpcDTO storeDto = this.rmiOrgStoreService.getOrgStoreBase(storeCode);
        log.info("\u95e8\u5e97\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)storeDto));
        if (storeDto == null) {
            return ApiResult.ok();
        }
        String ouCode = storeDto.getOuCode();
        String brandCode = storeDto.getBrandCode();
        ItmItemBusinessRpcPagingParam param = new ItmItemBusinessRpcPagingParam();
        if (StrUtil.isNotBlank((CharSequence)ouCode)) {
            param.setBuCodes(Collections.singletonList(ouCode));
        }
        if (StrUtil.isNotBlank((CharSequence)brandCode)) {
            param.setBrandList(Collections.singletonList(brandCode));
        }
        if (StrUtil.isNotBlank((CharSequence)storeAuthorityRpcPageDTO.getItemCodeName())) {
            param.setItemCodeName(storeAuthorityRpcPageDTO.getItemCodeName());
        }
        if (CollUtil.isNotEmpty((Collection)storeAuthorityRpcPageDTO.getItemType2s())) {
            param.setItemType2s(storeAuthorityRpcPageDTO.getItemType2s());
        }
        param.setCurrent(Integer.valueOf(storeAuthorityRpcPageDTO.getCurrent() + 2));
        param.setSize(storeAuthorityRpcPageDTO.getSize());
        PagingVO<ItmItemBusinessRpcPagingDTO> itemBusinessRpcDTOS = this.rmiItemService.findItemBusinessRpcDtoByParam(param);
        long total = itemBusinessRpcDTOS.getTotal();
        List records = itemBusinessRpcDTOS.getRecords();
        log.info("\u8c03\u7528\u57fa\u7840\u57df\u5206\u9875\u67e5\u8be2\u5546\u54c1\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)records));
        List<Long> fetchImageIds = records.stream().map(ItmItemBusinessRpcPagingDTO::getSpuId).toList();
        List<ItmItemAttachmentProviderDTO> skuImgList = this.rmiItemService.findSkuImgByItemIds(fetchImageIds);
        Map<Object, Object> skuImgMap = new HashMap();
        if (CollUtil.isNotEmpty(skuImgList)) {
            skuImgMap = skuImgList.stream().collect(Collectors.groupingBy(ItmItemAttachmentProviderDTO::getItemId));
        }
        ArrayList<ItemObject> itemInfoList = new ArrayList<ItemObject>();
        for (ItmItemBusinessRpcPagingDTO dto : records) {
            ItemObject itemInfo = new ItemObject();
            itemInfo.setItemCode(dto.getItemCode());
            itemInfo.setItemId(dto.getItemId());
            itemInfo.setItemName(dto.getItemName());
            itemInfo.setUom(dto.getUom());
            itemInfo.setUomName(dto.getUomName());
            itemInfo.setTaxRate(dto.getTaxRate2());
            itemInfo.setBrand(dto.getBrand());
            itemInfo.setBrandName(dto.getBrandName());
            itemInfo.setItemCateCode(dto.getItemCateCode());
            itemInfo.setItemCateFullName(dto.getItemCateFullName());
            itemInfo.setItemCatePathName(dto.getItemCatePathName());
            itemInfo.setSpec(dto.getSpec());
            itemInfo.setSpuCode(dto.getSpuCode());
            itemInfo.setSpuName(dto.getSpuName());
            itemInfo.setPackageSpec(dto.getPackageSpec());
            itemInfo.setSuppCode(dto.getSuppCode());
            itemInfo.setSuppName(dto.getSuppName());
            itemInfo.setUom2(dto.getUom2());
            itemInfo.setUom2Name(dto.getUom2Name());
            itemInfo.setItemType(dto.getItemType2());
            itemInfo.setSpuId(dto.getSpuId());
            List v = (List)skuImgMap.get(dto.getSpuId());
            if (CollUtil.isNotEmpty((Collection)v)) {
                ItmItemAttachmentProviderDTO itmItemAttachmentProviderDTO = v.stream().filter(i -> i.getMajor() != null && i.getMajor() != false).findFirst().orElse(null);
                if (itmItemAttachmentProviderDTO == null) {
                    itmItemAttachmentProviderDTO = (ItmItemAttachmentProviderDTO)v.get(0);
                }
                String fileUrl = this.serverAddr + "/coordinator/el-fsm-service/api/fsm/download/" + itmItemAttachmentProviderDTO.getFileCode();
                itemInfo.setImgUrl(fileUrl);
            }
            itemInfoList.add(itemInfo);
        }
        PagingVO result = new PagingVO();
        result.setRecords(itemInfoList);
        result.setTotal(total);
        log.info("\u95e8\u5e97\u8981\u8d27\u6743\u9650\u6570\u636e-\u5206\u9875:{}", (Object)JSONUtil.toJsonStr((Object)result));
        return ApiResult.ok((Object)result);
    }

    @SysCodeProc
    public ApiResult<StoreAuthorityRespDTO> getStoreAuthorityData(StoreAuthorityRpcDTO storeAuthorityRpcDTO) {
        String storeCode = storeAuthorityRpcDTO.getStoreCode();
        if (StrUtil.isBlank((CharSequence)storeCode)) {
            throw new BusinessException("\u53c2\u6570\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrgStoreBaseRpcDTO storeDto = this.rmiOrgStoreService.getOrgStoreBase(storeCode);
        log.info("\u95e8\u5e97\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)storeDto));
        if (storeDto == null) {
            return ApiResult.ok();
        }
        StoreAuthorityRespDTO storeAuthorityRespDTO = StoreInfoConvert.INSTANCE.toStoreAuthorityRespDTO(storeDto);
        String ouCode = storeAuthorityRespDTO.getOuCode();
        String brandCode = storeAuthorityRespDTO.getBrandCode();
        List<ItmItemBusinessRpcDTO> itmItemBusinessRpcDTOS = this.rmiItemService.findItmItemBusinessByBUCodeAndBrand(ouCode, brandCode);
        log.info("\u8c03\u7528\u57fa\u7840\u57df\u67e5\u8be2\u5546\u54c1\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(itmItemBusinessRpcDTOS));
        ArrayList<StoreAuthorityRespDTO.ItemInfo> itemInfoList = new ArrayList<StoreAuthorityRespDTO.ItemInfo>();
        for (ItmItemBusinessRpcDTO dto : itmItemBusinessRpcDTOS) {
            StoreAuthorityRespDTO.ItemInfo itemInfo = new StoreAuthorityRespDTO.ItemInfo();
            itemInfo.setItemCode(dto.getItemCode());
            itemInfo.setItemId(dto.getId());
            itemInfo.setItemName(dto.getItemName());
            itemInfo.setUom(dto.getUom());
            itemInfo.setUomName(dto.getUomName());
            itemInfo.setTaxRate(dto.getTaxRate2());
            itemInfoList.add(itemInfo);
        }
        storeAuthorityRespDTO.setItemInfos(itemInfoList);
        log.info("\u95e8\u5e97\u8981\u8d27\u6743\u9650\u6570\u636e:{}", (Object)JSONUtil.toJsonStr((Object)storeAuthorityRespDTO));
        return ApiResult.ok((Object)storeAuthorityRespDTO);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveAuthority(ScpManAuthorityRpcSaveVO saveVO) {
        log.info("\u4fdd\u5b58\u8ba1\u5212\u5458\u6743\u9650RPC\u63a5\u53e3\u5f00\u59cb\uff1a{}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        ScpManAuthoritySaveVO scpManAuthoritySaveVO = ScpDemandAuthorityConvert.INSTANCE.rpc2SaveVo(saveVO);
        Long id = this.scpsmanAuthorityService.saveScpAuthority(scpManAuthoritySaveVO);
        log.info("\u4fdd\u5b58\u8ba1\u5212\u5458\u6743\u9650RPC\u63a5\u53e3\u7ed3\u675f\uff1a{}", (Object)id);
        return ApiResult.ok((Object)id);
    }

    public StoreAuthorityRpcServiceImpl(RmiOrgStoreRpcService rmiOrgStoreService, RmiItemService rmiItemService, ScpsmanAuthorityService scpsmanAuthorityService) {
        this.rmiOrgStoreService = rmiOrgStoreService;
        this.rmiItemService = rmiItemService;
        this.scpsmanAuthorityService = scpsmanAuthorityService;
    }
}

