/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.collect;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectCancelVO;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectParamVO;
import com.elitesland.scp.application.facade.vo.resp.collect.ScpUserCollectRespVO;
import com.elitesland.scp.application.facade.vo.save.collect.ScpUserCollectSaveVO;
import com.elitesland.scp.application.service.collect.ScpUserCollectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79fb\u52a8\u7aef-\u6536\u85cf\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/collect"}, produces={"application/json"})
public class ScpUserCollectController {
    private static final Logger log = LoggerFactory.getLogger(ScpUserCollectController.class);
    private final ScpUserCollectService scpUserCollectService;

    @ApiOperation(value="\u6211\u7684\u6536\u85cf\u5217\u8868")
    @PostMapping(value={"/user"})
    public ApiResult<List<ScpUserCollectRespVO>> getList(@RequestBody @Validated ScpUserCollectParamVO paramVO) {
        log.info("[SCP-COLLECT] getList  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        return ApiResult.ok(this.scpUserCollectService.getUserList(paramVO));
    }

    @ApiOperation(value="\u6dfb\u52a0\u6536\u85cf\u4ea7\u54c1")
    @PostMapping(value={"/add"})
    public ApiResult<Long> save(@RequestBody @Validated ScpUserCollectSaveVO saveVO) {
        log.info("[SCP-COLLECT] save  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        return ApiResult.ok((Object)this.scpUserCollectService.add(saveVO));
    }

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u6536\u85cf\u4ea7\u54c1")
    @PostMapping(value={"/batch/add"})
    public ApiResult<Void> batchSave(@RequestBody @Validated List<ScpUserCollectSaveVO> saveVOList) {
        log.info("[SCP-COLLECT] batch save  saveVO ={}", (Object)JSONUtil.toJsonStr(saveVOList));
        this.scpUserCollectService.batchSave(saveVOList);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u53d6\u6d88\u6536\u85cf\u4ea7\u54c1")
    @PostMapping(value={"/cancel"})
    public ApiResult<Object> cancel(@RequestBody @Validated ScpUserCollectCancelVO cancelVO) {
        log.info("[SCP-COLLECT] cancel  spuId ={}", (Object)JSONUtil.toJsonStr((Object)cancelVO));
        this.scpUserCollectService.deleteBySpuIdAndUid(cancelVO);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u53d6\u6d88\u6536\u85cf\u4ea7\u54c1")
    @PostMapping(value={"/batch/cancel"})
    public ApiResult<Object> cancel(@RequestBody @Validated List<ScpUserCollectCancelVO> cancelVOList) {
        log.info("[SCP-COLLECT] batch cancel  spuId ={}", (Object)JSONUtil.toJsonStr(cancelVOList));
        cancelVOList.forEach(this.scpUserCollectService::deleteBySpuIdAndUid);
        return ApiResult.ok();
    }

    public ScpUserCollectController(ScpUserCollectService scpUserCollectService) {
        this.scpUserCollectService = scpUserCollectService;
    }
}

