package com.elitesland.scp.application.service.scpsman;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanDetailInfoRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoQueryVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @Auther: Mark
 * @Date: 2024/3/21 16:11
 * @Description:
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class ScpsmanExportServiceImpl implements DataExport<SalesmanDetailInfoRespVO, SalesmanInfoQueryVO> {

    private final ScpsmanInfoService scpsmanInfoService;

    @Override
    public String getTmplCode() {
        return "yst_scp_scpsman_export";
    }

    @Override
    public PagingVO<SalesmanDetailInfoRespVO> executeExport(SalesmanInfoQueryVO queryParamVO) {
        return scpsmanInfoService.querySalesmanAllInfo(queryParamVO).getData();
    }
}
