package com.elitesland.scp.domain.entity.scpsman;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitesland.support.provider.constant.SupportBusinessObjectConstants;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 19:24
 * @Description:
 */
@Entity
@Table(name = "scpsman_region")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "scpsman_region", comment = "计划员关联区域表")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "scpsman_region", description = "计划员关联区域表")
public class ScpsmanRegionDO extends BaseModel implements Serializable {

    @ApiModelProperty("计划员主表id")
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '计划员主表id'")
    private Long masId;

    @Column()
    @ApiModelProperty("区域类型, [UDC]yst-suplan:SCPSMAN_REGION_TYPE")
    private String regionType;

    @ApiModelProperty("区域id")
    @Column(name = "region_id", columnDefinition = "bigint(20) comment '区域id'")
    private Long regionId;

    @ApiModelProperty("区域code")
    @Column(name = "region_code", columnDefinition = "varchar(20) comment '区域code'")
    @BusinessParam(fieldPermissionEnabled = false, relatedBusinessObject = SupportBusinessObjectConstants.ORG_REGION, relatedField = "regionCode")
    private String regionCode;

    @ApiModelProperty("区域名称")
    @Column(name = "region_name", columnDefinition = "varchar(20) comment '区域名称'")
    private String regionName;

}
