/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.provider.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageParam;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderConvert;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderDConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.dto.order.ScpDemandOrderCancelDTO;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcAllocDTO;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcDTO;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcQuantityDTO;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcRecvQtyDTO;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcSrcDoc2NoDTO;
import com.elitesland.scp.dto.order.ScpDemandOrderRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.param.ScpOrderUnRecvParamVO;
import com.elitesland.scp.service.order.ScpDemandOrderDRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/scp/orderDRpc"})
public class ScpDemandOrderDRpcServiceImpl
implements ScpDemandOrderDRpcService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderDRpcServiceImpl.class);
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final StoreReceiveService storeReceiveService;
    private final ScpDemandOrderDRepo scpDemandOrderDRepo;
    private final ScpDemandOrderRepo scpDemandOrderRepo;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateDemandOrderDetail(List<ScpDemandOrderDRpcDTO> rpcDTOS) {
        log.info("\u3010updateDemandOrderDetail\u3011\u66f4\u65b0\u8ba2\u8d27\u5355\u660e\u7ec6\uff1a{}", (Object)JSONUtil.toJsonStr(rpcDTOS));
        for (ScpDemandOrderDRpcDTO rpcDTO : rpcDTOS) {
            this.scpDemandOrderDDomainService.saveDemandOrderD(ScpDemandOrderDConvert.INSTANCE.rpcDtoToSaveVO(rpcDTO));
        }
        return ApiResult.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateAllocationQuantity(List<ScpDemandOrderDRpcAllocDTO> rpcDTOS) {
        log.info("\u3010updateDemandOrderDetail\u3011\u66f4\u65b0\u8ba2\u8d27\u5355\u914d\u8d27\u6570\u91cf\uff1a{}", (Object)JSONUtil.toJsonStr(rpcDTOS));
        for (ScpDemandOrderDRpcAllocDTO rpcDTO : rpcDTOS) {
            this.scpDemandOrderDDomainService.updateAllocQuantity(rpcDTO.getId(), rpcDTO.getAllocationQuantity());
        }
        return ApiResult.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateQuantity(List<ScpDemandOrderDRpcQuantityDTO> rpcDTOS) {
        log.info("\u3010updateDemandOrderDetail\u3011\u66f4\u65b0\u8ba2\u8d27\u5355\u53d1\u8d27\u6570\u91cf\uff1a{}", (Object)JSONUtil.toJsonStr(rpcDTOS));
        for (ScpDemandOrderDRpcQuantityDTO rpcDTO : rpcDTOS) {
            this.scpDemandOrderDDomainService.updateQuantity(rpcDTO.getId(), rpcDTO.getQuantity());
        }
        List<Long> ids = rpcDTOS.stream().map(ScpDemandOrderDRpcQuantityDTO::getId).collect(Collectors.toList());
        List masIds = this.scpDemandOrderDDomainService.getMasIdByDId(ids).stream().distinct().collect(Collectors.toList());
        for (Long masId : masIds) {
            this.scpDemandOrderDomainService.updateDocStatusById(masId, "DELIVERY");
        }
        return ApiResult.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> updateSrcDoc2No(List<ScpDemandOrderDRpcSrcDoc2NoDTO> rpcDTOS) {
        log.info("\u66f4\u65b0\u91c7\u8d2d\u5355SRM\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSONUtil.toJsonStr(rpcDTOS));
        for (ScpDemandOrderDRpcSrcDoc2NoDTO dto : rpcDTOS) {
            String docNo = dto.getSrcDoc2No();
            this.scpDemandOrderDDomainService.updateSrcDoc2No(dto.getId(), docNo);
        }
        return ApiResult.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateRecvQty(List<ScpDemandOrderDRpcRecvQtyDTO> rpcDTOS) {
        log.info("\u3010updateDemandOrderDetail\u3011\u66f4\u65b0\u8ba2\u8d27\u5355\u6536\u8d27\u6570\u91cf\uff1a{}", (Object)JSONUtil.toJsonStr(rpcDTOS));
        for (ScpDemandOrderDRpcRecvQtyDTO rpcDTO : rpcDTOS) {
            this.scpDemandOrderDDomainService.updateRecvQty(rpcDTO.getId(), rpcDTO.getRecvQty());
        }
        List<Long> ids = rpcDTOS.stream().map(ScpDemandOrderDRpcRecvQtyDTO::getId).collect(Collectors.toList());
        List masIds = this.scpDemandOrderDDomainService.getMasIdByDId(ids).stream().distinct().collect(Collectors.toList());
        for (Long masId : masIds) {
            this.scpDemandOrderDomainService.updateDocStatusById(masId, "RECV");
        }
        return ApiResult.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> cancelOrder(ScpDemandOrderCancelDTO cancelDTO) {
        log.info("\u3010cancelOrder\u3011\u8ba2\u8d27\u5355\u53d6\u6d88\uff1a{}", (Object)JSONUtil.toJsonStr((Object)cancelDTO));
        if (CollUtil.isEmpty((Collection)cancelDTO.getDIds())) {
            return ApiResult.ok();
        }
        this.scpDemandOrderDDomainService.cancelOrderByDIds(cancelDTO.getDIds());
        List<ScpDemandOrderDDO> byMasIdAndStatus = this.scpDemandOrderDRepoProc.findByMasIdAndStatusNotAndProjectFeeFlag(cancelDTO.getId(), ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode(), false);
        if (CollUtil.isEmpty(byMasIdAndStatus)) {
            this.scpDemandOrderRepo.updateDocStatusById(cancelDTO.getId(), ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode());
        }
        return ApiResult.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> payCallback(ScpDemandOrderCancelDTO cancelDTO) {
        log.info("\u3010payCallback\u3011\u8ba2\u8d27\u5355\u652f\u4ed8\u56de\u4f20\uff1a{}", (Object)JSONUtil.toJsonStr((Object)cancelDTO));
        this.scpDemandOrderDDomainService.updatePayStatus(cancelDTO.getDIds(), ScpUdcEnum.PAY_STATUS_PAYED.getValueCode());
        this.scpDemandOrderDomainService.updatePayStatusById(cancelDTO.getId());
        return ApiResult.ok();
    }

    public ApiResult<Long> checkUnRecvOrder(ScpOrderUnRecvParamVO paramVO) {
        StoreReceivePageParam storeReceivePageParam = new StoreReceivePageParam();
        storeReceivePageParam.setStatusList(List.of("CE"));
        storeReceivePageParam.setRtType("R");
        storeReceivePageParam.setStoreIds(List.of(paramVO.getStoreId()));
        storeReceivePageParam.setCreateDateTo(paramVO.getDateTime());
        return ApiResult.ok((Object)this.storeReceiveService.countStoreReceive(storeReceivePageParam));
    }

    public ApiResult<List<ScpDemandOrderDRpcDTO>> findByMasId(Long masId) {
        if (masId == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "masId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ScpDemandOrderDDTO> orderDList = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(masId);
        if (CollectionUtils.isEmpty(orderDList)) {
            return ApiResult.ok(new ArrayList());
        }
        orderDList = orderDList.stream().filter(d -> d.getProjectFeeFlag() == false).collect(Collectors.toList());
        return ApiResult.ok(ScpDemandOrderDConvert.INSTANCE.dto2RpcDTO(orderDList));
    }

    public ApiResult<List<ScpDemandOrderRpcDTO>> findByDocNos(List<String> docNos) {
        log.info("\u3010findByDocNos\u3011\u67e5\u8be2\u95e8\u5e97\u8ba2\u8d27\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSONUtil.toJsonStr(docNos));
        List<ScpDemandOrderDO> demandOrderByDocNos = this.scpDemandOrderRepoProc.findDemandOrderByDocNos(docNos);
        List<ScpDemandOrderRpcDTO> demandOrderDRpcDTOS = ScpDemandOrderConvert.INSTANCE.dos2RPCDtos(demandOrderByDocNos);
        return ApiResult.ok(demandOrderDRpcDTOS);
    }

    public ScpDemandOrderDRpcServiceImpl(ScpDemandOrderDomainService scpDemandOrderDomainService, ScpDemandOrderDDomainService scpDemandOrderDDomainService, StoreReceiveService storeReceiveService, ScpDemandOrderDRepo scpDemandOrderDRepo, ScpDemandOrderRepo scpDemandOrderRepo, ScpDemandOrderRepoProc scpDemandOrderRepoProc, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc) {
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.storeReceiveService = storeReceiveService;
        this.scpDemandOrderDRepo = scpDemandOrderDRepo;
        this.scpDemandOrderRepo = scpDemandOrderRepo;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
    }
}

