package com.elitesland.scp.domain.service.setting;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.setting.ScpOrderSettingSaveVO;
import com.elitesland.scp.infr.dto.setting.ScpOrderSettingDTO;

import java.util.List;
import java.util.Optional;

public interface ScpOrderSettingDomainService {

    /**
     * 单据类型配置查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpOrderSettingPageRespVO> queryOrderSettingList(ScpOrderSettingPageParamVO paramVO);

    /**
     * 单据类型配置详情查询
     *
     * @param id
     * @return
     */
    Optional<ScpOrderSettingDTO> findOrderSettingById(Long id);

    /**
     * 单据类型配置保存
     *
     * @param saveVO 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    Long saveOrderSetting(ScpOrderSettingSaveVO saveVO);

    /**
     * 单据类型配置状态变更
     *
     * @param ids    单据类型配置的ID列表
     * @param enable 单据类型配置的状态，true表示启用，false表示禁用
     */
    void enableOrderSetting(List<Long> ids, Boolean enable);

    /**
     * 删除单据类型配置
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 根据参数查询单据类型配置
     *
     * @param paramVO
     * @return
     */
    List<ScpOrderSettingRespVO> findByParam(ScpOrderSettingParamVO paramVO);

    /**
     * 根据单据类型查询商品分类
     *
     * @param businessType
     * @return
     */
    List<String> findItemCatesByBusinessType(String businessType, String type);



    List<String> findDeliveryTypeByBusinessType(String businessType, String type);

    /**
     * 根据单据类型查询缓存
     *
     * @param businessType
     * @return
     */
    ScpOrderSettingRespVO findCacheByBusinessType(String businessType, String type);


    List<ScpOrderSettingRespVO> findCacheByBusinessType(List<String> businessTypeList, String type);

    /**
     * 查询启用的单据类型配置
     *
     * @return
     */
    List<ScpOrderSettingRespVO> findEnabledSetting();
}
