package com.elitesland.scp.infr.repo.order;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.order.ScpDemandOrderExportRespVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpsmanAuthQueryParam;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.item.QScpCateItemDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanInfoDO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanRegionDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


@Component
@RequiredArgsConstructor
public class ScpDemandOrderExportRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpDemandOrderDO scpDemandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
    private final QScpDemandOrderDDO scpDemandOrderDDO = QScpDemandOrderDDO.scpDemandOrderDDO;
    private final QScpsmanRegionDO scpsmanRegionDO = QScpsmanRegionDO.scpsmanRegionDO;
    public PagingVO<ScpDemandOrderExportRespVO> executeExport(ScpDemandOrderPageParamVO queryParam) {

        JPAQuery<ScpDemandOrderExportRespVO> jpaQuery;
        jpaQuery = jpaQueryFactory
                .select(Projections.bean(
                        ScpDemandOrderExportRespVO.class,
                        Expressions.cases()
                                .when(scpDemandOrderDO.payStatus.eq("PAYED")).then("已付款")
                                .when(scpDemandOrderDO.payStatus.eq("PAYING")).then("支付中")
                                .when(scpDemandOrderDO.payStatus.eq("WAIT_PAY")).then("待支付")
                                .otherwise(scpDemandOrderDO.payStatus)
                                .as("payStatusName"),
                        Expressions.cases()
                                .when(scpDemandOrderDO.docStatus.eq("DRAFT")).then("草稿")
                                .when(scpDemandOrderDO.docStatus.eq("WT")).then("未分配")
                                .when(scpDemandOrderDO.docStatus.eq("DOING")).then("部分分配")
                                .when(scpDemandOrderDO.docStatus.eq("DONE")).then("全部分配")
                                .when(scpDemandOrderDO.docStatus.eq("PUSHING")).then("部分推送")
                                .when(scpDemandOrderDO.docStatus.eq("PUSHED")).then("全部推送")
                                .when(scpDemandOrderDO.docStatus.eq("TIMEOUT")).then("已超时")
                                .when(scpDemandOrderDO.docStatus.eq("PART_SHIP")).then("部分发货")
                                .when(scpDemandOrderDO.docStatus.eq("SHIP")).then("已发货")
                                .when(scpDemandOrderDO.docStatus.eq("PART_RECV")).then("部分收货")
                                .when(scpDemandOrderDO.docStatus.eq("RECV")).then("已收货")
                                .when(scpDemandOrderDO.docStatus.eq("CLOSE")).then("已取消")
                                .otherwise(scpDemandOrderDO.docStatus)
                                .as("docStatusName"),
                        Expressions.cases()
                                .when(scpDemandOrderDO.apprStatus.eq("DRAFT")).then("待审批")
                                .when(scpDemandOrderDO.apprStatus.eq("DOING")).then("审批中")
                                .when(scpDemandOrderDO.apprStatus.eq("COMPLETE")).then("已审批")
                                .otherwise(scpDemandOrderDO.apprStatus)
                                .as("apprStatusName"),
                        scpDemandOrderDO.createTime.as("createTime"),
                        scpDemandOrderDO.demandWhStCode.as("demandWhStCode"),
                        scpDemandOrderDO.demandWhStName.as("demandWhStName"),
                        scpDemandOrderDO.docCode.as("docCode"),
                        scpDemandOrderDO.etaDate.as("etaDate"),
                        Expressions.cases()
                                .when(scpDemandOrderDO.businessType.eq("10")).then("新店首批商品")
                                .when(scpDemandOrderDO.businessType.eq("20")).then("首批设备")
                                .when(scpDemandOrderDO.businessType.eq("30")).then("老店增补")
                                .when(scpDemandOrderDO.businessType.eq("40")).then("店长自采")
                                .otherwise(scpDemandOrderDO.businessType)
                                .as("businessTypeName"),
                        scpDemandOrderDDO.itemCode.as("itemCode"),
                        scpDemandOrderDDO.itemName.as("itemName"),
                        Expressions.cases()
                                .when(scpDemandOrderDDO.deliveryType.eq("110")).then("区配")
                                .when(scpDemandOrderDDO.deliveryType.eq("120")).then("统配")
                                .when(scpDemandOrderDDO.deliveryType.eq("130")).then("直送")
                                .when(scpDemandOrderDDO.deliveryType.eq("140")).then("甲指乙采")
                                .when(scpDemandOrderDDO.deliveryType.eq("140")).then("水果")
                                .otherwise(scpDemandOrderDDO.deliveryType)
                                .as("deliveryType"),
                        scpDemandOrderDDO.demandQuantity.as("demandQuantity"),
                        // 折扣比例
                        scpDemandOrderDDO.discount.stringValue().as("discount"),
                        // 折前单价 - IF(d.project_fee_flag = 1, 0, d.price)
                        Expressions.cases()
                                .when(scpDemandOrderDDO.projectFeeFlag.isTrue()).then(Expressions.constant("0"))
                                .otherwise(scpDemandOrderDDO.price.stringValue())
                                .as("price"),

                        // 折后单价 - IF(d.project_fee_flag = 1, 0, d.settlement_price)
                        Expressions.cases()
                                .when(scpDemandOrderDDO.projectFeeFlag.isTrue()).then(Expressions.constant("0"))
                                .otherwise(scpDemandOrderDDO.settlementPrice.stringValue())
                                .as("settlementPrice"),

                        // 折后金额 - IF(d.project_fee_flag = 1, 0, d.settlement_amt)
                        Expressions.cases()
                                .when(scpDemandOrderDDO.projectFeeFlag.isTrue()).then(Expressions.constant("0"))
                                .otherwise(scpDemandOrderDDO.settlementAmt.stringValue())
                                .as("settlementAmt"),
                        scpDemandOrderDDO.suppWhCode.as("suppWhCode"),
                        scpDemandOrderDDO.suppWhName.as("suppWhName"),
                        scpDemandOrderDDO.activityCode.as("activityCode"),
                        scpDemandOrderDDO.minNum.as("minNum"),
                        // 处理是否强配
                        Expressions.cases()
                                .when(scpDemandOrderDDO.activityCode.isNull()).then("非强配")
                                .otherwise("强配")
                                .as("isForcedAllocation")
                )).from(scpDemandOrderDO)
                .innerJoin(scpDemandOrderDDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));

        // 添加查询条件
        if (queryParam != null) {
            // 门店权限
            var predicateScpsmanAuth = appendScpsmanAuth(queryParam);
            if (predicateScpsmanAuth != null) {
                jpaQuery.where(predicateScpsmanAuth);
            }

            jpaQuery.where(where(queryParam));
        }

        // 分页和排序
        Objects.requireNonNull(queryParam).setPaging(jpaQuery);
        jpaQuery.orderBy(scpDemandOrderDO.createTime.desc());

        return PagingVO.<ScpDemandOrderExportRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    private Predicate appendScpsmanAuth(ScpsmanAuthQueryParam queryParam) {
        if (Boolean.TRUE.equals(queryParam.getAllRegion())) {
            return null;
        }

        BooleanExpression predicateScpsmanRegion = scpDemandOrderDO.demandWhStCode.in(
                JPAExpressions.select(scpsmanRegionDO.regionCode)
                        .from(scpsmanRegionDO)
                        .where(
                                scpsmanRegionDO.masId.eq(queryParam.getScpsmanInfoId()).and(scpsmanRegionDO.regionType.eq(com.elitesland.scp.application.enums.ScpUdcEnum.SCPSMAN_REGION_TYPE_STORE.getValueCode()))
                        ));
        BooleanExpression predicateRegionStore = CollUtil.isEmpty(queryParam.getRegionStoreCodes()) ? null : scpDemandOrderDO.demandWhStCode.in(queryParam.getRegionStoreCodes());
        if (predicateScpsmanRegion == null) {
            return predicateRegionStore;
        }
        return predicateRegionStore == null ? predicateScpsmanRegion : predicateScpsmanRegion.or(predicateRegionStore);
    }

    private Predicate where(ScpDemandOrderPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDemandCode())) {
            predicates.add(scpDemandOrderDO.demandCode.like(paramVO.getDemandCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getBusinessType())) {
            predicates.add(scpDemandOrderDO.businessType.eq(paramVO.getBusinessType()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            predicates.add(scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getDocStatus())) {
            predicates.add(scpDemandOrderDO.docStatus.eq(paramVO.getDocStatus()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocStatusList())) {
            predicates.add(scpDemandOrderDO.docStatus.in(paramVO.getDocStatusList()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.like(paramVO.getDemandWhStCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getKeyword())) {
            Predicate predicate = scpDemandOrderDDO.isNotNull();
            predicates.add(ExpressionUtils.and(predicate, scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%"))));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            predicates.add(scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty(paramVO.getDemandDateTo())) {
            predicates.add(scpDemandOrderDO.demandDate.between(paramVO.getDemandDateFrom(), paramVO.getDemandDateTo()));
        }
        if (CollUtil.isNotEmpty(paramVO.getDemandWhStCodes())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.in(paramVO.getDemandWhStCodes()));
        }
        if (CollUtil.isNotEmpty(paramVO.getIdSet())) {
            predicates.add(scpDemandOrderDDO.masId.add(scpDemandOrderDDO.id.coalesce(0L)).in(paramVO.getIdSet()));
        }
        if (StrUtil.isNotBlank(paramVO.getSuppWhCode())) {
            predicates.add(scpDemandOrderDDO.suppWhCode.eq(paramVO.getSuppWhCode()));
        }
        if (CollUtil.isNotEmpty(paramVO.getSuppWhCodes())) {
            predicates.add(scpDemandOrderDDO.suppWhCode.in(paramVO.getSuppWhCodes()));
        }
        if (StrUtil.isNotBlank(paramVO.getSupplyType())) {
            predicates.add(scpDemandOrderDDO.supplyType.eq(paramVO.getSupplyType()));
        }
        if (StrUtil.isNotBlank(paramVO.getPayStatus())) {
            predicates.add(scpDemandOrderDO.payStatus.eq(paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getApprStatus())) {
            predicates.add(scpDemandOrderDO.apprStatus.eq(paramVO.getApprStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpDemandOrderDO.docType.eq(paramVO.getDocType()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getPayStatusList())) {
            predicates.add(scpDemandOrderDO.payStatus.in(paramVO.getPayStatusList()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            predicates.add(scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (paramVO.getReplyFlag() != null) {
            predicates.add(scpDemandOrderDO.replyFlag.eq(paramVO.getReplyFlag()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getCreateTimeFrom()) && !ObjectUtils.isEmpty(paramVO.getCreateTimeTo())) {
            predicates.add(scpDemandOrderDO.createTime.between(paramVO.getCreateTimeFrom(), paramVO.getCreateTimeTo()));
        }
        if (paramVO.getCreatorId() != null) {
            predicates.add(scpDemandOrderDO.createUserId.eq(paramVO.getCreatorId()));
        }
        if (paramVO.getIsReceived() != null) {
            if (paramVO.getIsReceived()) {
                predicates.add(scpDemandOrderDDO.recvQty.goe(scpDemandOrderDDO.demandQuantity));
            } else {
                predicates.add(scpDemandOrderDDO.recvQty.isNull().or(scpDemandOrderDDO.recvQty.lt(scpDemandOrderDDO.demandQuantity)));
            }
        }
        return ExpressionUtils.allOf(predicates);
    }
}
