/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.mrp;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpDPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDExportRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDPlanRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDetailRespVO;
import com.elitesland.scp.application.facade.vo.save.mrp.ScpMrpDPlanSaveVO;
import com.elitesland.scp.domain.convert.mrp.ScpMrpDConvert;
import com.elitesland.scp.domain.convert.mrp.ScpMrpDPlanConvert;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDDO;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDPlanDO;
import com.elitesland.scp.domain.service.mrp.ScpMrpDDomainService;
import com.elitesland.scp.infr.repo.mrp.ScpMrpDPlanRepo;
import com.elitesland.scp.infr.repo.mrp.ScpMrpDRepo;
import com.elitesland.scp.infr.repo.mrp.ScpMrpDRepoProc;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpMrpDDomainServiceImpl
implements ScpMrpDDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpMrpDDomainServiceImpl.class);
    private final ScpMrpDRepo scpMrpDRepo;
    private final ScpMrpDPlanRepo scpMrpDPlanRepo;
    private final ScpMrpDRepoProc scpMrpDRepoProc;
    private final UdcProvider udcProvider;

    @Override
    @SysCodeProc
    public PagingVO<ScpMrpDRespVO> searchPage(ScpMrpDPageParam param) {
        List<Long> ids;
        List<ScpMrpDPlanDO> scpMrpDPlanDOList;
        PagingVO<ScpMrpDRespVO> pagingVO = this.scpMrpDRepoProc.pageQuery(param);
        if (pagingVO.isNotEmpty() && CollectionUtil.isNotEmpty(scpMrpDPlanDOList = this.scpMrpDPlanRepo.findByMasIdIn(ids = pagingVO.getRecords().stream().map(BaseViewModel::getId).collect(Collectors.toList())))) {
            Map pushStatusMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", "MRP_D_PUSH_STATUS");
            List<ScpMrpDPlanRespVO> scpMrpDPlanRespVOS = ScpMrpDPlanConvert.INSTANCE.doToRespVO(scpMrpDPlanDOList);
            Map<Long, List<ScpMrpDPlanRespVO>> planMap = scpMrpDPlanRespVOS.stream().peek(plan -> plan.setPushStatusName((String)pushStatusMap.get(plan.getPushStatus()))).collect(Collectors.groupingBy(ScpMrpDPlanRespVO::getMasId));
            pagingVO.getRecords().forEach(record -> record.setScpMrpDPlanRespVOList((List)planMap.get(record.getId())));
        }
        return pagingVO;
    }

    @Override
    public List<ScpMrpDRespVO> findByMasId(Long masId) {
        List<ScpMrpDDO> scpMrpDDOList = this.scpMrpDRepo.findByMasId(masId);
        if (CollectionUtil.isNotEmpty(scpMrpDDOList)) {
            return ScpMrpDConvert.INSTANCE.doToRespVO(scpMrpDDOList);
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasIds(List<Long> masIds) {
        this.scpMrpDRepo.deleteByMasIds(masIds);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        this.scpMrpDRepo.deleteByIds(ids);
    }

    @Override
    public List<Long> findIdsByMasIds(List<Long> masIds) {
        return this.scpMrpDRepoProc.findIdsByMasIds(masIds);
    }

    @Override
    public List<ScpMrpDRespVO> findByMasIds(List<Long> masIds) {
        List<ScpMrpDDO> scpMrpDDOList = this.scpMrpDRepo.findByMasIdIn(masIds);
        if (CollectionUtil.isNotEmpty(scpMrpDDOList)) {
            return ScpMrpDConvert.INSTANCE.doToRespVO(scpMrpDDOList);
        }
        return Collections.emptyList();
    }

    @Override
    public ScpMrpDRespVO findById(Long id) {
        return this.scpMrpDRepo.findById(id).map(ScpMrpDConvert.INSTANCE::doToRespVO).orElse(null);
    }

    @Override
    @Transactional
    public List<ScpMrpDDO> save(List<ScpMrpDDO> scpMrpDDOList) {
        return this.scpMrpDRepo.saveAll(scpMrpDDOList);
    }

    @Override
    @Transactional
    public void savePlan(List<ScpMrpDPlanSaveVO> scpMrpDPlanSaveVOList) {
        this.scpMrpDPlanRepo.saveAll(ScpMrpDPlanConvert.INSTANCE.saveVoToDo(scpMrpDPlanSaveVOList));
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpMrpDExportRespVO> queryExport(ScpMrpDPageParam param) {
        return this.scpMrpDRepoProc.queryExport(param);
    }

    @Override
    public List<ScpMrpDRespVO> findByIds(List<Long> ids) {
        List scpMrpDDOList = this.scpMrpDRepo.findAllById(ids);
        if (CollectionUtil.isEmpty((Collection)scpMrpDDOList)) {
            return Collections.emptyList();
        }
        return ScpMrpDConvert.INSTANCE.doToRespVO(scpMrpDDOList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateNetDemand(Long id, BigDecimal netDemand) {
        this.scpMrpDRepoProc.updateNetDemand(id, netDemand);
    }

    @Override
    public List<ScpMrpDetailRespVO> findDetailByMasId(Long masId) {
        return this.scpMrpDRepoProc.findDetailByMasId(masId);
    }

    public ScpMrpDDomainServiceImpl(ScpMrpDRepo scpMrpDRepo, ScpMrpDPlanRepo scpMrpDPlanRepo, ScpMrpDRepoProc scpMrpDRepoProc, UdcProvider udcProvider) {
        this.scpMrpDRepo = scpMrpDRepo;
        this.scpMrpDPlanRepo = scpMrpDPlanRepo;
        this.scpMrpDRepoProc = scpMrpDRepoProc;
        this.udcProvider = udcProvider;
    }
}

