/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.calendar;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarParamVO;
import com.elitesland.scp.application.service.scpsman.BaseScpmanAuthorityParam;
import com.elitesland.scp.domain.entity.calendar.QScpSuppDemandCalendarDO;
import com.elitesland.scp.domain.entity.calendar.ScpSuppDemandCalendarDO;
import com.elitesland.scp.infr.dto.calendar.ScpSuppDemandCalendarDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ScpSuppDemandCalendarRepoProc
extends BaseRepoProc<ScpSuppDemandCalendarDO> {
    private static final QScpSuppDemandCalendarDO jpaQDo = QScpSuppDemandCalendarDO.scpSuppDemandCalendarDO;

    public ScpSuppDemandCalendarRepoProc() {
        super((EntityPathBase)jpaQDo);
    }

    public PagingVO<ScpSuppDemandCalendarPageVO> searchPage(ScpSuppDemandCalendarPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpSuppDemandCalendarPageVO.class, (Expression[])new Expression[]{ScpSuppDemandCalendarRepoProc.jpaQDo.suppId, ScpSuppDemandCalendarRepoProc.jpaQDo.suppCode, ScpSuppDemandCalendarRepoProc.jpaQDo.suppName, ScpSuppDemandCalendarRepoProc.jpaQDo.type, ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhId, ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhCode, ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhName, ScpSuppDemandCalendarRepoProc.jpaQDo.year, ScpSuppDemandCalendarRepoProc.jpaQDo.month})).distinct()).from((EntityPath)jpaQDo);
        if (param != null) {
            jpaQuery.where(this.where(param));
        }
        jpaQuery.orderBy(new OrderSpecifier[]{ScpSuppDemandCalendarRepoProc.jpaQDo.year.desc(), ScpSuppDemandCalendarRepoProc.jpaQDo.month.desc()});
        param.setPaging(jpaQuery);
        return PagingVO.builder().total(this.getCount(param).longValue()).records(jpaQuery.fetch()).build();
    }

    public Predicate where(ScpSuppDemandCalendarPageParamVO param) {
        String month;
        DateTimeFormatter formatter;
        String year;
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (StringUtils.isNotEmpty((String)param.getSuppCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.suppCode.eq((Object)param.getSuppCode()));
        }
        if (StringUtils.isNotEmpty((String)param.getStoreWhCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhCode.eq((Object)param.getStoreWhCode()));
        }
        if (StringUtils.isNotEmpty((String)param.getType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.type.eq((Object)param.getType()));
        }
        if (param.getStartDate() != null) {
            year = String.valueOf(param.getStartDate().getYear());
            formatter = DateTimeFormatter.ofPattern("MM");
            month = param.getStartDate().format(formatter);
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.year.goe((Comparable)((Object)year)).and((Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.month.goe((Comparable)((Object)month))));
        }
        if (param.getEndDate() != null) {
            year = String.valueOf(param.getEndDate().getYear());
            formatter = DateTimeFormatter.ofPattern("MM");
            month = param.getEndDate().format(formatter);
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.year.loe((Comparable)((Object)year)).and((Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.month.loe((Comparable)((Object)month))));
        }
        if (Boolean.TRUE.equals(param.getScpmanAuthority())) {
            predicate = this.whereScpmanAuthority(param, (Predicate)predicate);
        }
        return predicate;
    }

    private Predicate whereScpmanAuthority(BaseScpmanAuthorityParam param, Predicate predicate) {
        if (CollectionUtils.isNotEmpty(param.getStores()) && CollectionUtils.isNotEmpty(param.getWhCodes())) {
            predicate = ExpressionUtils.or((Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.type.eq((Object)"1").and((Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhCode.in(param.getWhCodes())), (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.type.eq((Object)"0").and((Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhCode.in(param.getStores())));
        } else if (CollectionUtils.isNotEmpty(param.getWhCodes())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.type.eq((Object)"1"));
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhCode.in(param.getWhCodes()));
        } else if (CollectionUtils.isNotEmpty(param.getStores())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.type.eq((Object)"0"));
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhCode.in(param.getStores()));
        }
        return predicate;
    }

    private Long getCount(ScpSuppDemandCalendarPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectDistinct(new Expression[]{ScpSuppDemandCalendarRepoProc.jpaQDo.suppId, ScpSuppDemandCalendarRepoProc.jpaQDo.suppCode, ScpSuppDemandCalendarRepoProc.jpaQDo.suppName, ScpSuppDemandCalendarRepoProc.jpaQDo.type, ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhId, ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhCode, ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhName, ScpSuppDemandCalendarRepoProc.jpaQDo.year, ScpSuppDemandCalendarRepoProc.jpaQDo.month}).from((EntityPath)jpaQDo);
        if (param != null) {
            jpaQuery.where(this.where(param));
        }
        return jpaQuery.fetch().size();
    }

    public List<ScpSuppDemandCalendarDTO> findSuppCalendarListByParam(ScpSuppDemandCalendarParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpSuppDemandCalendarDTO.class, (Expression[])new Expression[]{ScpSuppDemandCalendarRepoProc.jpaQDo.suppId, ScpSuppDemandCalendarRepoProc.jpaQDo.suppCode, ScpSuppDemandCalendarRepoProc.jpaQDo.suppName, ScpSuppDemandCalendarRepoProc.jpaQDo.type, ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhId, ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhCode, ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhName, ScpSuppDemandCalendarRepoProc.jpaQDo.year, ScpSuppDemandCalendarRepoProc.jpaQDo.month, ScpSuppDemandCalendarRepoProc.jpaQDo.id, ScpSuppDemandCalendarRepoProc.jpaQDo.workStatus, ScpSuppDemandCalendarRepoProc.jpaQDo.day})).from((EntityPath)jpaQDo);
        if (param != null) {
            jpaQuery.where(this.where(param));
        }
        return jpaQuery.fetch();
    }

    public Predicate where(ScpSuppDemandCalendarParamVO param) {
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (StringUtils.isNotEmpty((String)param.getSuppCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.suppCode.eq((Object)param.getSuppCode()));
        }
        if (StringUtils.isNotEmpty((String)param.getStoreWhCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.storeWhCode.eq((Object)param.getStoreWhCode()));
        }
        if (StringUtils.isNotEmpty((String)param.getType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.type.eq((Object)param.getType()));
        }
        if (StringUtils.isNotEmpty((String)param.getYear())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.year.eq((Object)param.getYear()));
        }
        if (StringUtils.isNotEmpty((String)param.getMonth())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpSuppDemandCalendarRepoProc.jpaQDo.month.eq((Object)param.getMonth()));
        }
        return predicate;
    }
}

