package com.elitesland.scp.application.facade.vo.boh;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class StoreReceiveCategoryInfoVO implements Serializable {

    @ApiModelProperty("订货集ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long demandId;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货集名称")
    private String demandName;

    @ApiModelProperty("订货单编码")
    private String docCode;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("单据状态")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("类型")
    private String type;
    private String typeName;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("业务类型")
    @SysCode(sys = "yst-suplan", mod = "BUSINESS_TYPE")
    private String businessType;
    private String businessTypeName;

    @ApiModelProperty("需求仓库id/门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long demandWhStId;

    @ApiModelProperty("需求仓库编码/门店编码")
    private String demandWhStCode;

    @ApiModelProperty("需求仓库名称/门店名称")
    private String demandWhStName;

    @ApiModelProperty("需求日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("装修门店")
    private String renovationStore;

    @ApiModelProperty("是否可以确认收货")
    private Boolean canConfirm;

    @ApiModelProperty("仓发品物流状态")
    private List<StoreReceivePageVO> whDeliveryStatus;

    @ApiModelProperty("直发品物流状态")
    private List<StoreReceivePageVO> directDeliveryStatus;
}