package com.elitesland.scp.application.facade.vo.template;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * @Auther: Mark
 * @Date: 2024/4/24 16:34
 * @Description:
 */
@Data
@ApiModel(description = "分页查询结果")
public class DemandOrderPageRespVO implements Serializable {

    @ApiModelProperty("订货模板id")
    private Long id;

    @ApiModelProperty("订货模板编号")
    private String demandTemCode;

    @ApiModelProperty("订货模板名称")
    private String demandTemName;

    @ApiModelProperty("起始日期")
    private Date startDate;

    @ApiModelProperty("截止日期")
    private Date endDate;

    @ApiModelProperty("详细日期")
    private String detailedTime;

    @ApiModelProperty("状态，1:启用，0:禁用")
    private Integer demandTemStatus;

    @ApiModelProperty("商品种数")
    private BigDecimal typeNumber;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String type;
    private String typeName;


}
