package com.elitesland.scp.application.service.export;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.survey.ScpSurveyAnalysisExportRespVO;
import com.elitesland.scp.domain.service.survey.SurveyService;
import com.elitesland.scp.domain.vo.survey.SurveyPagingParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 22日 15:35
 * @version: 1.0
 */
@Component
@RequiredArgsConstructor
public class ScpSurveyAnalysisExportImpl implements DataExport<ScpSurveyAnalysisExportRespVO, SurveyPagingParam> {

    private final SurveyService surveyService;

    @Override
    public String getTmplCode() {
        return "scp_survey_analysis_export";
    }

    @Override
    public PagingVO<ScpSurveyAnalysisExportRespVO> executeExport(SurveyPagingParam param) {
        return surveyService.exportSearch(param);
    }


}
