package com.elitesland.scp.application.web.authority;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityRegionParamVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityStatusParamVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityWhStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityRespVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthoritySaveVO;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "计划员权限接口")
@RestController
@RequestMapping(value = "/authority", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpsmanAuthorityController {
    private final ScpsmanAuthorityService scpsmanAuthorityService;

    @ApiOperation(value = "计划员权限-分页查询")
    @PostMapping(value = "/list")
    public ApiResult<PagingVO<ScpManAuthorityPageRespVO>> queryAuthorit(@RequestBody ScpManAuthorityParam paramVO) {
        log.info("[SCP-MAN-AUTHORITY] queryAuthorit, paramVO ={}", JSON.toJSONString(paramVO));
        return ApiResult.ok(scpsmanAuthorityService.queryAuthorit(paramVO));
    }

    @ApiOperation("计划员权限-查询计划员权限明细信息")
    @GetMapping("/findIdOne/{id}")
    public ApiResult<ScpsmanAuthorityRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-MAN-AUTHORITY] findIdOne, id ={}", id);
        return scpsmanAuthorityService.findIdOne(id).map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }

    /**
     * 1.修改数据与数据库数据重复报错提示
     * 2.新增数据在数据库已存在报错
     * @param saveVO
     * @return
     */
    @PostMapping("/save")
    @ApiOperation("计划员权限 - 保存")
    public ApiResult<Long> saveDemandSet(@RequestBody @Validated ScpManAuthoritySaveVO saveVO) {
        log.info("[SCP-MAN-AUTHORITY] saveFranchisee  param ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpsmanAuthorityService.saveScpAuthority(saveVO));
    }

    @ApiOperation("计划员权限 - 启用/禁用")
    @PostMapping("/change")
    public ApiResult<Object> changeStatus(@RequestBody @Validated ScpManAuthorityStatusParamVO paramVO) {
        log.info("[SCP-MAN-AUTHORITY] changeStatus paramVO = {}", JSON.toJSONString(paramVO));
        scpsmanAuthorityService.changeStatus(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value = "计划员权限 - 删除")
    @PostMapping(value = "/delete")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-MAN-AUTHORITY]  delete paramVO = {}", JSON.toJSONString(ids));
        scpsmanAuthorityService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation("计划员权限 - 按区域添加门店/仓库")
    @PostMapping("/region")
    public ApiResult<Object> region(@RequestBody ScpManAuthorityRegionParamVO paramVO) {
        log.info("[SCP-MAN-AUTHORITY] 按区域添加门店/仓库 paramVO = {}", JSON.toJSONString(paramVO));
        scpsmanAuthorityService.region(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation("计划员权限 - 添加门店/仓库")
    @PostMapping("/saveWhStore")
    public ApiResult<Object> saveWhStore(@RequestBody ScpManAuthorityWhStoreParamVO paramVO) {
        log.info("[SCP-MAN-AUTHORITY] 添加门店/仓库 paramVO = {}", JSON.toJSONString(paramVO));
        scpsmanAuthorityService.saveWhStore(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value = "计划员权限 -明细删除")
    @PostMapping(value = "/detail/delete")
    public ApiResult<Object> detailDelete(@RequestBody List<Long> ids) {
        log.info("[SCP-MAN-AUTHORITY]  计划员权限 -明细删除 paramVO = {}", JSON.toJSONString(ids));
        scpsmanAuthorityService.deleteByDIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value = "自动根据员工创建")
    @GetMapping(value = "/createdByEmployee")
    public ApiResult<Boolean> createdByEmployee(@RequestParam(name = "employeeCode") String employeeCode) {
        return scpsmanAuthorityService.createdByEmployee(employeeCode);
    }
}
