package com.elitesland.scp.application.web.item;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemParam;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.service.item.ScpCateItemService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.param.CateItemRpcParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Slf4j
@Api(tags = "中台-品类商品")
@RestController
@RequestMapping(value = "/cate/item", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class CateItemController {

    private final ScpCateItemService scpCateItemService;


    @PostMapping("/bind")
    @ApiOperation("品类商品 - 绑定")
    public ApiResult<Void> bind(@RequestBody @Validated ScpCateItemParam cateStoreParam) {
        scpCateItemService.bindItem(cateStoreParam);
        return ApiResult.ok();
    }

    @PostMapping("/remove")
    @ApiOperation("品类商品 - 取消绑定")
    public ApiResult<Void> remove(@RequestBody @Validated List<Long> ids) {
        scpCateItemService.remove(ids);
        return ApiResult.ok();
    }

    @PostMapping("/query")
    @ApiOperation("品类商品 - 品类查询")
    public ApiResult<List<ScpCateItemDTO>> query(@RequestBody @Validated CateItemRpcParam cateItemRpcParam) {
        return scpCateItemService.query(cateItemRpcParam);
    }

    @ApiOperation("品类商品 - 是否热销")
    @PostMapping("/changeHotFlag")
    public ApiResult<Object> changeHotFlag(@RequestBody @Validated ScpCateItemHotParamVO paramVO) {
        log.info("[SCP-CATE-ITEM] changeHotFlag paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpCateItemService.changeHotFlag(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation("品类商品 - 商品分页查询")
    @PostMapping("/page")
    public ApiResult<PagingVO<ScpCateItemRespVO>> page(@RequestBody @Validated ScpCateItemPageParamVO paramVO) {
        log.info("[SCP-CATE-ITEM] page paramVO = {}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpCateItemService.page(paramVO));
    }

    @ApiOperation("品类商品 - 排序")
    @GetMapping("/sortNo/{id}/{sorNo}")
    public ApiResult<ScpDemandOrderRespVO> saveSortNo(@PathVariable Long id, @PathVariable Integer sorNo) {
        log.info("[SCP-CATE-ITEM] saveSortNo, id ={}", id);
        scpCateItemService.saveSortNo(id, sorNo);
        return ApiResult.ok();
    }

    @ApiOperation("品类商品 - 商品维护分页查询")
    @PostMapping("/sku/paging")
    public ApiResult<PagingVO<ScpCateItemPageVO>> skuPaging(@RequestBody ScpCateItemPageParamVO param) {
        return ApiResult.ok(scpCateItemService.skuPage(param));
    }

}
