package com.elitesland.scp.application.web.mrp;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpDPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDRespVO;
import com.elitesland.scp.application.facade.vo.save.mrp.ScpMrpDPlanSaveVO;
import com.elitesland.scp.application.service.mrp.ScpMrpDService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "物料需求计划明细")
@RestController
@RequestMapping(value = "/mrp/detail", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpMrpDController {

    private final ScpMrpDService scpMrpDService;

    @ApiOperation(value = "物料需求计划明细 - 分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpMrpDRespVO>> page(@RequestBody ScpMrpDPageParam param) {
        log.info("[SCP-MRP-DETAIL] page  param ={}", JSONUtil.toJsonStr(param));
        return ApiResult.ok(scpMrpDService.page(param));
    }

    @ApiOperation(value = "物料需求计划明细 - 编辑")
    @PostMapping(value = "/plan/save")
    public ApiResult<Object> findByMasId(@RequestBody List<ScpMrpDPlanSaveVO> scpMrpDPlanSaveVOList) {
        log.info("[SCP-MRP-DETAIL] savePlan  param ={}", JSONUtil.toJsonStr(scpMrpDPlanSaveVOList));
        scpMrpDService.savePlan(scpMrpDPlanSaveVOList);
        return ApiResult.ok();
    }

    @PutMapping("/delete")
    @ApiOperation("物料需求计划 - 删除")
    public ApiResult deleteByIds(@RequestBody List<Long> ids) {
        log.info("[SCP-MRP-DETAIL] delete  param ={}", JSONUtil.toJsonStr(ids));
        scpMrpDService.deleteByIds(ids);
        return ApiResult.ok();
    }
}
