package com.elitesland.scp.infr.repo.item;

import com.elitesland.scp.domain.entity.item.ScpCateItemDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;

public interface ScpCateItemRepo extends JpaRepository<ScpCateItemDO, Long>, QuerydslPredicateExecutor<ScpCateItemDO> {

    @Modifying()
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_cate_item set pre_sale_status = ?2 where id in ?1 ", nativeQuery = true)
    void updatePreStatusByIdIn(Collection<Long> ids, Boolean preSaleStatus);


    @Modifying()
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_cate_item set up_down_status = ?2 where id in ?1 ", nativeQuery = true)
    void updateUpDownStatusByIdIn(Collection<Long> ids, Boolean upDownStatus);
}
