package com.elitesland.scp.infr.repo.order;

import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderReplyPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyPageRespVO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderReplyDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpDemandOrderReplyRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpDemandOrderDO scpDemandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
    private static final QScpDemandOrderReplyDO scpDemandOrderReplyDO = QScpDemandOrderReplyDO.scpDemandOrderReplyDO;

    public long countOrderReply(ScpDemandOrderReplyPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderReplyDO.count())
                .from(scpDemandOrderReplyDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderReplyDO.orderId));
        jpaQuery.where(this.whereOrderReply(paramVO));
        return jpaQuery.fetchCount();
    }

    private final QBean<ScpDemandOrderReplyPageRespVO> pageList = Projections.bean(
            ScpDemandOrderReplyPageRespVO.class,
            scpDemandOrderDO.type,
            scpDemandOrderDO.demandCode,
            scpDemandOrderDO.demandName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.docCode,
            scpDemandOrderDO.docType,
            scpDemandOrderDO.docCls,
            scpDemandOrderDO.demandWhStCode,
            scpDemandOrderDO.demandWhStName,
            scpDemandOrderReplyDO.orderScore,
            scpDemandOrderReplyDO.expressScore,
            scpDemandOrderReplyDO.comment,
            scpDemandOrderReplyDO.pics,
            scpDemandOrderReplyDO.creator,
            scpDemandOrderReplyDO.createUserId,
            scpDemandOrderReplyDO.createTime,
            scpDemandOrderReplyDO.updater,
            scpDemandOrderReplyDO.modifyUserId,
            scpDemandOrderReplyDO.modifyTime,
            scpDemandOrderReplyDO.remark
    );

    public List<ScpDemandOrderReplyPageRespVO> queryOrderReply(ScpDemandOrderReplyPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpDemandOrderReplyDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderReplyDO.orderId));
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpDemandOrderReplyDO);
        jpaQuery.where(this.whereOrderReply(paramVO));
        return jpaQuery.fetch();
    }


    private Predicate whereOrderReply(ScpDemandOrderReplyPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDemandCode())) {
            predicates.add(scpDemandOrderDO.demandCode.like(paramVO.getDemandCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            predicates.add(scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getDocStatus())) {
            predicates.add(scpDemandOrderDO.docStatus.eq(paramVO.getDocStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpDemandOrderDO.docType.eq(paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.like(paramVO.getDemandWhStCode() + "%"));
        }
        if (!ObjectUtils.isEmpty(paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty(paramVO.getDemandDateTo())) {
            predicates.add(scpDemandOrderDO.demandDate.between(paramVO.getDemandDateFrom(), paramVO.getDemandDateTo()));
        }
        if (paramVO.getExpressScore() != null) {
            predicates.add(scpDemandOrderReplyDO.expressScore.eq(paramVO.getExpressScore()));
        }
        if (paramVO.getOrderScore() != null) {
            predicates.add(scpDemandOrderReplyDO.orderScore.eq(paramVO.getOrderScore()));
        }
        return ExpressionUtils.allOf(predicates);
    }


}
