package com.elitesland.scp.infr.repo.wqf;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.scp.domain.entity.wqf.QScpWqfEntAccountApplyDDO;
import com.elitesland.scp.domain.entity.wqf.QScpWqfEntAccountApplyDO;
import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountApplyDDO;
import com.elitesland.scp.infr.dto.wqf.ScpWqfEntAccountApplyDDTO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Component;

import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-02-27
* @Version 1.0
**/
@Component
public class ScpWqfEntAccountApplyDRepoProc extends BaseRepoProc<ScpWqfEntAccountApplyDDO> {

    private static final QScpWqfEntAccountApplyDDO qScpWqfEntAccountApplyDDO = QScpWqfEntAccountApplyDDO.scpWqfEntAccountApplyDDO;

    private static final QScpWqfEntAccountApplyDO qScpWqfEntAccountApplyDO = QScpWqfEntAccountApplyDO.scpWqfEntAccountApplyDO;

    public ScpWqfEntAccountApplyDRepoProc(){
        super(qScpWqfEntAccountApplyDDO);
    }


    public List<ScpWqfEntAccountApplyDDTO> findByStoreIdAndOuId(List<Long> storeIds, Long ouId){
        QScpWqfEntAccountApplyDO scpWqfEntAccountApplyDO = QScpWqfEntAccountApplyDO.scpWqfEntAccountApplyDO;
        JPAQuery<ScpWqfEntAccountApplyDDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpWqfEntAccountApplyDDTO.class,
                qScpWqfEntAccountApplyDDO.storeId,
                qScpWqfEntAccountApplyDDO.masId,
                scpWqfEntAccountApplyDO.ouId
        )).from(qScpWqfEntAccountApplyDDO)
                .leftJoin(scpWqfEntAccountApplyDO).on(qScpWqfEntAccountApplyDDO.masId.eq(scpWqfEntAccountApplyDO.id));
        return jpaQuery.where(qScpWqfEntAccountApplyDDO.storeId.in(storeIds)
                .and(scpWqfEntAccountApplyDO.ouId.eq(ouId))).fetch();
    }

    public List<ScpWqfEntAccountApplyDDTO> findAccountBindNotifyDetail(String docNo,List<String> bankAccounts){
        JPAQuery<ScpWqfEntAccountApplyDDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpWqfEntAccountApplyDDTO.class,
                        qScpWqfEntAccountApplyDDO.id,
                        qScpWqfEntAccountApplyDDO.storeId,
                        qScpWqfEntAccountApplyDO.ouId,
                        qScpWqfEntAccountApplyDDO.storeCode,
                        qScpWqfEntAccountApplyDDO.masId,
                        qScpWqfEntAccountApplyDDO.accountType,
                        qScpWqfEntAccountApplyDDO.bankAccount,
                        qScpWqfEntAccountApplyDDO.openBank,
                        qScpWqfEntAccountApplyDDO.bankBranchCode,
                        qScpWqfEntAccountApplyDDO.branchName,
                        qScpWqfEntAccountApplyDO.docNo
                )).from(qScpWqfEntAccountApplyDDO)
                .leftJoin(qScpWqfEntAccountApplyDO).on(qScpWqfEntAccountApplyDDO.masId.eq(qScpWqfEntAccountApplyDO.id));
        jpaQuery.where(qScpWqfEntAccountApplyDO.docNo.eq(docNo).and(qScpWqfEntAccountApplyDDO.bankAccount.in(bankAccounts)));
        return jpaQuery.fetch();
    }



}