package com.elitesland.scp.job.task;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.job.config.JobConstant;
import com.elitesland.scp.job.service.ScpDemandOrderCloseJobService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ScpDemandOrderCloseHandler {
    @Autowired
    private ScpDemandOrderCloseJobService scpDemandOrderCloseJobService;

    @XxlJob(JobConstant.SCP_DEMAND_ORDER_CLOSE_HANDLER)
    public ReturnT<String> scpDemandOrderCloseHandler(String param) {
        try {
            scpDemandOrderCloseJobService.autoCloseDemandOrder();
        } catch (Exception e) {
            log.error("订货订货单超时自动关闭定时任务执行失败：", e);
            throw new BusinessException("订货集定时任务执行失败:" + e.getMessage());
        }
        return ReturnT.SUCCESS;
    }
}
