package com.elitesland.scp.rmi;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.support.provider.org.param.OrgAddrQueryRpcParam;
import com.elitesland.support.provider.org.service.OrgAddrRpcService;
import java.time.LocalDateTime;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/4/7 7:19 下午
 * @version:v1.0
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class RmiOrgOutRpcService {

    private final OrgAddrRpcService orgAddrRpcService;


    public OrgAddrDetailsRpcDTO findRpcDtoByAddrNo(Long addrNo) {
        log.info("调用支撑域-根据地址号获取地址薄详情，时间：{}，入参：{}", LocalDateTime.now(), addrNo);
        try {
            OrgAddrQueryRpcParam param = new OrgAddrQueryRpcParam();
            param.setAddrNo(addrNo);
            ApiResult<OrgAddrDetailsRpcDTO> apiResult = orgAddrRpcService.findRpcDtoByParam(param);

            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("findRpcDtoByAddrNo error:", e);
        }
        return null;
    }

}
