package com.elitesland.scp.utils;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import lombok.extern.slf4j.Slf4j;
import lombok.val;

/**
 * @Auther: Mark
 * @Date: 2024/3/27 10:32
 * @Description:
 */
@Slf4j
public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static void handleRootException(Exception e) {
        val exception = cn.hutool.core.exceptions.ExceptionUtil.getRootCause(e);
        if (exception instanceof BusinessException) {
            log.error("接口调用过程中根节点异常信息：", exception);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, exception.getMessage());
        }
    }
}
