/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.app.util;

import com.elitesland.scp.application.web.app.enums.LoginAccountType;
import java.util.regex.Pattern;

public class AccountIdentifierUtil {
    private static final Pattern PHONE_NUMBER_PATTERN = Pattern.compile("^1[3-9]\\d{9}$");
    private static final Pattern EMPLOYEE_ID_PATTERN = Pattern.compile("^[A-Za-z]{4}\\d{4,}$");

    public static LoginAccountType identifyAccountType(String input) {
        if (input == null || input.trim().isEmpty()) {
            return LoginAccountType.INVALID;
        }
        String trimmedInput = input.trim();
        if (AccountIdentifierUtil.isPhoneNumber(trimmedInput)) {
            return LoginAccountType.PHONE_NUMBER;
        }
        return LoginAccountType.EMPLOYEE_ID;
    }

    private static boolean isPhoneNumber(String input) {
        return PHONE_NUMBER_PATTERN.matcher(input).matches();
    }
}

