package com.elitesland.scp.application.facade.vo.cart;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("订单确认页面返回参数")
public class OrderConfirmRespVO implements Serializable {
    private static final long serialVersionUID = 6630648855762814199L;

    @ApiModelProperty("SPU商品ID")
    private Long spuId;

    @ApiModelProperty("SPU商品编码")
    @NotNull(message = "SPU商品编码不能为空")
    private String spuCode;

    @ApiModelProperty("SPU商品名称")
    private String spuName;

    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品分类")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("需求数量")
    private BigDecimal demandQuantity;

    @ApiModelProperty("拆分需求数量")
    private BigDecimal allocationDeQuantity;

    @ApiModelProperty("订货单位")
    private String unit;

    @ApiModelProperty("订货单位")
    private String unitName;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("币种，默认CNY")
    private String currency;

    @ApiModelProperty("供应类型，WH:仓库，SUPP:供应商")
    @SysCode(sys = "yst-suplan", mod = "SUPPLY_DEMAND_TYPE")
    private String supplyType;
    private String supplyTypeName;

    @ApiModelProperty("供应仓库id、供应商id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppWhId;

    @ApiModelProperty("供应仓库编码、供应商编码")
    private String suppWhCode;

    @ApiModelProperty("供应仓库名称、供应商名称")
    private String suppWhName;

    @ApiModelProperty("采购公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("采购公司编码")
    private String ouCode;

    @ApiModelProperty("采购公司名称")
    private String ouName;

    @ApiModelProperty("运费是否计费")
    private Boolean freightFlag;

    @ApiModelProperty("运费比例")
    private BigDecimal freightRatio;

    @ApiModelProperty("分配比例")
    private BigDecimal ratio;

    @ApiModelProperty("销售公司编码")
    private String saleOuCode;

    @ApiModelProperty("销售公司名称")
    private String saleOuName;

    @ApiModelProperty("销售客户编码")
    private String saleCustCode;

    @ApiModelProperty("强配活动编码")
    private String activityCode;

    @ApiModelProperty("强配活动Id")
    private Long activityId;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("销售单价（不含服务费）")
    private BigDecimal salePrice;

    @ApiModelProperty("结算单价")
    private BigDecimal settlementPrice;

    @ApiModelProperty("结算货款单价")
    private BigDecimal settlementSalePrice;

    @ApiModelProperty("科技费价格")
    private BigDecimal tefPrice;

    @ApiModelProperty("营销费价格")
    private BigDecimal mefPrice;

    @ApiModelProperty("运营费价格")
    private BigDecimal oefPrice;

    @ApiModelProperty("是否收取项目费用")
    private Boolean isProjFeeCharged;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuCode;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuCode;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuCode;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuName;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuName;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuName;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;
}
