package com.elitesland.scp.application.facade.vo.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "购物车批量保存对象", description = "购物车")
public class StoreCartBatchSaveVO implements Serializable {
    private static final long serialVersionUID = 250368359843709323L;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "采购车类型", required = true)
    @NotBlank(message = "采购车类型不能为空")
    private String cartType;

    @ApiModelProperty("购物车保存明细对象")
    private List<StoreCartSaveVO> cartSaveVOList;
}
