package com.elitesland.scp.application.facade.vo.order;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ScpDemandOrderExportRespVO  extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -4607660124307291057L;
    // 状态名称字段（从DO的状态码转换而来）
    @ApiModelProperty("支付状态名称")
    private String payStatusName;        // 支付状态名称

    @ApiModelProperty("单据状态名称")
    private String docStatusName;        // 单据状态名称

    @ApiModelProperty("审批状态名称")
    private String apprStatusName;       // 审批状态名称

    // 来自 ScpDemandOrderDO 的字段
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;    // 创建时间

    @ApiModelProperty("需求仓库编码/门店编码")
    private String demandWhStCode;       // 需求仓库编码/门店编码

    @ApiModelProperty("需求仓库名称/门店名称")
    private String demandWhStName;       // 需求仓库名称/门店名称

    @ApiModelProperty("订货单编码")
    private String docCode;              // 订货单编码

    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;       // 预计到货日期

    @ApiModelProperty("业务类型名称")
    private String businessTypeName;     // 业务类型名称

    // 来自 ScpDemandOrderDDO 的字段
    @ApiModelProperty("商品编码")
    private String itemCode;             // 商品编码

    @ApiModelProperty("商品名称")
    private String itemName;             // 商品名称

    @ApiModelProperty("配送类型")
    private String deliveryType;         // 配送类型

    @ApiModelProperty("需求数量")
    private BigDecimal demandQuantity;   // 需求数量

    // 价格相关字段（根据projectFeeFlag条件计算）
   // discount
    @ApiModelProperty("折扣比例")
    private String discount;

    @ApiModelProperty("折前单价（含税单价）")
    private String price;            // 折前单价（含税单价）

    @ApiModelProperty("结算单价（折后单价）")
    private String settlementPrice;  // 结算单价（折后单价）

    @ApiModelProperty("结算金额（折后金额）")
    private String settlementAmt;    // 结算金额（折后金额）

    // 供应商信息
    @ApiModelProperty("供应仓库编码、供应商编码")
    private String suppWhCode;           // 供应仓库编码、供应商编码

    @ApiModelProperty("供应仓库名称、供应商名称")
    private String suppWhName;           // 供应仓库名称、供应商名称

    // 强配活动信息
    @ApiModelProperty("强配活动编码")
    private String activityCode;         // 强配活动编码

    @ApiModelProperty("最小强配数量")
    private BigDecimal minNum;           // 最小强配数量（注意：DO中是BigDecimal类型）

    // 是否强配标志（计算字段）
    @ApiModelProperty("是否强配：0-否，1-是")
    private String isForcedAllocation;  // 是否强配：0-否，1-是
}