package com.elitesland.scp.application.facade.vo.resp.authority;


import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


@Data
@ApiModel(value = "计划员权限门店查询", description = "计划员权限门店查询")
public class ScpManAuthorityStoreInfoVO implements Serializable {
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 计划员id
     */
    @ApiModelProperty(name = "计划员id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long scpsmanId;

    /**
     * 计划员编码
     */
    @ApiModelProperty(name = "计划员编码")
    private String scpsmanNo;

    /**
     * 计划员姓名
     */
    @ApiModelProperty(name = "计划员姓名")
    private String scpsman;

    /**
     * 门店id/仓库id
     */
    @ApiModelProperty(name = "门店id/仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long stWhId;

    /**
     * 门店编码/仓库编码
     */
    @ApiModelProperty(name = "门店编码/仓库编码")
    private String stWhCode;

    /**
     * 门店名称/仓库名称
     */
    @ApiModelProperty(name = "门店名称/仓库名称")
    private String stWhName;
}
