package com.elitesland.scp.application.facade.vo.resp.order;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("订货集分页返回")
public class ScpDemandOrderCheckRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -4607660124307291057L;

    @ApiModelProperty("唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long uniqueId;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-suplan", mod = "DEO_STATUS")
    private String docStatus;
    private String docStatusName;

    /**
     * 商品信息 集合
     */
    @ApiModelProperty("商品编码集合")
    private List<String> itemCodeList;

    @ApiModelProperty("商品图片集合")
    private List<String> itemImgUrls;
    @ApiModelProperty(value = "商品图片")
    private String imgUrl;
    @ApiModelProperty(value = "装修门店集")
    private String renovationStore;
    private String renovationStoreName;

    /**
     * 下单时间
     */
    @ApiModelProperty("下单时间")
    private LocalDateTime createTime;
    /**
     * 下单件数
     */
    @ApiModelProperty("下单件数")
    private Integer qty;
    /**
     * 关联订单
     */
    @ApiModelProperty("关联门店订货单")
    private String relateDocNo;
    private String relateDocNoName;


}
