package com.elitesland.scp.application.facade.vo.resp.order;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("订货订单明细返回(管理端)")
public class ScpDemandOrderDMgmtRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -4099575500015071676L;

    @ApiModelProperty("订货订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("原始id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sourceId;

    @ApiModelProperty("分配单据编码")
    private String srcDocNo;

    @ApiModelProperty("分配单据2编码")
    private String srcDoc2No;

    @ApiModelProperty("SPU商品编码")
    @NotNull(message = "SPU商品编码不能为空")
    private String spuItemCode;

    @ApiModelProperty("spu名称")
    private String spuItemName;

    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品分类")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("订货单位")
    private String unit;
    @ApiModelProperty("订货单位")
    private String unitName;

    @ApiModelProperty("需求数量")
    private BigDecimal demandQuantity;

    @ApiModelProperty("币种，默认CNY")
    private String currency;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否运费行，true:是，false:否")
    private Boolean freightLineFlag;

    @ApiModelProperty("最小强配数量")
    private BigDecimal minNum;

    @ApiModelProperty("强配活动编码")
    private String activityCode;

    @ApiModelProperty("配送类型")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String deliveryType;
    private String deliveryTypeName;

    @ApiModelProperty("费用类型")
    @SysCode(sys = "yst-suplan", mod = "COST_TYPE")
    private String costType;
    private String costTypeName;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty("供应明细信息")
    private List<ScpDemandOrderDMgmtRespVO.SupplyItem> itemList;

    @Data
    public static class SupplyItem implements Serializable {

        @ApiModelProperty("原始id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long id;

        @ApiModelProperty("行号")
        private BigDecimal lineNo;

        private static final long serialVersionUID = 2988979500466179584L;
        @ApiModelProperty("分配数量")
        private BigDecimal allocationQuantity;

        @ApiModelProperty("拆分需求数量")
        private BigDecimal allocationDeQuantity;

        @ApiModelProperty("供应类型，WH:仓库，SUPP:供应商")
        @SysCode(sys = "yst-suplan", mod = "SUPPLY_DEMAND_TYPE")
        private String supplyType;
        private String supplyTypeName;

        @ApiModelProperty("供应仓库id、供应商id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long suppWhId;

        @ApiModelProperty("供应仓库编码、供应商编码")
        private String suppWhCode;

        @ApiModelProperty("供应仓库名称、供应商名称")
        private String suppWhName;

        @ApiModelProperty("供应商ID")
        private Long suppId;

        @ApiModelProperty("供应商编码")
        private String suppCode;

        @ApiModelProperty("供应商名称")
        private String suppName;

        @ApiModelProperty("采购公司id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long ouId;

        @ApiModelProperty("采购公司编码")
        private String ouCode;

        @ApiModelProperty("采购公司名称")
        private String ouName;

        @ApiModelProperty("分配单据id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long srcDocId;

        @ApiModelProperty("分配单据编码")
        private String srcDocNo;

        @ApiModelProperty("分配单据类别")
        private String srcDocCls;
        private String srcDocClsName;

        @ApiModelProperty("分配单据明细行号")
        private String srcDocLineNo;

        @ApiModelProperty("发货数量")
        private BigDecimal quantity;

        @ApiModelProperty("供应仓库/供应商份额")
        private BigDecimal ratio;

        @ApiModelProperty("计划数量")
        private BigDecimal planQuantity;

        @ApiModelProperty("是否已分配，true:是，false:否")
        private Boolean isCalculated;

        @ApiModelProperty("是否已推送, true:是，false:否")
        private Boolean isPushed;

        @ApiModelProperty("推送订单信息")
        private String syncMsg;

        @ApiModelProperty("订货单位")
        private String unit;

        @ApiModelProperty("订货单位")
        private String unitName;

        @ApiModelProperty("基本单位数量")
        private BigDecimal qty2;

        @ApiModelProperty("基本单位")
        private String uom2;
        private String uom2Name;

        @ApiModelProperty("单位转换系数")
        private BigDecimal uomRatio;

        @ApiModelProperty("含税单价")
        private BigDecimal price;

        @ApiModelProperty(name = "有效小数位数")
        private Integer decimalPlaces;

        @ApiModelProperty("运费是否计费")
        private Boolean freightFlag;

        @ApiModelProperty("运费比例")
        private BigDecimal freightRatio;

        @ApiModelProperty("销售公司编码")
        private String saleOuCode;

        @ApiModelProperty("销售公司名称")
        private String saleOuName;

        @ApiModelProperty("销售客户编码")
        private String saleCustCode;

        @ApiModelProperty(value = "含税金额")
        private BigDecimal planAmt;

        @ApiModelProperty("货款单价")
        private BigDecimal salePrice;

        @ApiModelProperty("货款金额")
        private BigDecimal saleAmt;

        @ApiModelProperty("付款状态")
        @SysCode(sys = "yst-suplan", mod = "PAY_STATUS")
        private String payStatus;
        private String payStatusName;

        @ApiModelProperty("收货数量")
        private BigDecimal recvQty;

        @ApiModelProperty("退货数量")
        private BigDecimal returnQty;

        @ApiModelProperty("赔付数量")
        private BigDecimal compensateQty;

        @ApiModelProperty("是否收取项目费用")
        private Boolean isProjFeeCharged;

        @ApiModelProperty(value = "商品图片")
        private String imgUrl;

        @ApiModelProperty("配送类型")
        @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
        private String deliveryType;
        private String deliveryTypeName;

        @ApiModelProperty("费用类型")
        @SysCode(sys = "yst-suplan", mod = "COST_TYPE")
        private String costType;
        private String costTypeName;

        @ApiModelProperty("结算单价")
        private BigDecimal settlementPrice;

        @ApiModelProperty("结算金额")
        private BigDecimal settlementAmt;

        @ApiModelProperty("结算货款单价")
        private BigDecimal settlementSalePrice;

        @ApiModelProperty("结算货款金额")
        private BigDecimal settlementSaleAmt;

        @ApiModelProperty("科技费价格")
        private BigDecimal tefPrice;

        @ApiModelProperty("营销费价格")
        private BigDecimal mefPrice;

        @ApiModelProperty("运营费价格")
        private BigDecimal oefPrice;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuCode;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuCode;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuCode;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuName;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuName;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuName;

        @ApiModelProperty("单据状态")
        @SysCode(sys = "yst-suplan", mod = "DEO_STATUS")
        private String status;
        private String statusName;

        @ApiModelProperty("折扣比例")
        private BigDecimal discount;
    }

}
