package com.elitesland.scp.application.service.cart;

import com.elitesland.scp.application.facade.vo.cart.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Auther: Mark
 * @Date: 2024/4/7 10:16
 * @Description:
 */
public interface ScpStoreCartService {

    /**
     * 购物车详情
     *
     * @param paramVO
     * @return
     */
    List<CartDetailRespVO> detail(CartDetailParamVO paramVO);

    /**
     * 获取购车商品数量
     *
     * @param param
     * @return
     */
    Map<String, Integer> getCartCount(StoreCartQueryParamVO param);

    /**
     * 新增购物车数据
     *
     * @param cartSaveVO
     */
    Map<Long, BigDecimal> saveCart(StoreCartSaveVO cartSaveVO);


    Map<Long, BigDecimal> saveAllocCart(StoreCartAllocSaveVO cartSaveVO);

    /**
     * 批量新增购物车数据
     *
     * @param storeCode
     * @param cartType
     * @param cartSaveVOS
     */
    void batchSaveCart(String storeCode, String cartType, List<StoreCartSaveVO> cartSaveVOS);

    /**
     * 删除购物车商品
     *
     * @param paramVO
     */
    void deleteItem(CartDeleteItemParamVO paramVO);

    /**
     * 购物车数据汇总
     *
     * @param paramVO
     * @return
     */
    CartDataSummaryRespVO dataSummary(CartDataSummaryParamVO paramVO);

    /**
     * 修改选中状态
     *
     * @param paramVO
     */
    void changeSelectedStatus(CartChangeSelectedStatusParamVO paramVO);

    /**
     * 全选/取消全选
     *
     * @param paramVO
     */
    void changeSelectedStatusAll(CartChangeSelectedStatusAllParamVO paramVO);

    /**
     * 下单确认
     *
     * @param paramVO
     * @return
     */
    OrderCheckRespVO order(OrderCheckParamVO paramVO);

    /**
     * 下单确认
     *
     * @param paramVO
     * @return
     */
    AiOrderRespVO aiOrder(AIOrderCheckParamVO paramVO);

    /**
     * 更新购物车数量
     *
     * @param cartCountParamVO
     * @return
     */
    void updateCount(CartCountParamVO cartCountParamVO);


    void updatePrice(CartPriceParamVO cartCountParamVO);
}
