package com.elitesland.scp.pay.controller;

import com.elitesland.scp.pay.service.RefundsService;
import com.tenpay.business.entpay.mse.sdk.api.Refund;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping("/refund")
public class RefundsController {

    private final RefundsService refundsService;

    // 退款申请
    @PostMapping("/create/{paymentId}")
    public Refund create(@PathVariable("paymentId") String paymentId) throws EntpayException {
        log.info("退款申请请求参数：{}", paymentId);
        return refundsService.refundOrder(paymentId);
    }

    // 退款查询（内单号）
    @GetMapping("/retrieve/{refundId}")
    public Refund retrieve(@PathVariable("refundId") String refundId) throws EntpayException {
        log.info("退款查询(内单号)请求参数：{}", refundId);
        return Refund.retrieve(refundId);
    }

    // 退款查询（外单号）
    @GetMapping("/retrieve/out-refund-id/{outRefundId}")
    public Refund retrieveByOutRefundId(@PathVariable("outRefundId") String outRefundId) throws EntpayException {
        log.info("退款查询(外单号)请求参数：{}", outRefundId);
        return Refund.retrieveByOutRefundId(outRefundId);
    }

}
