/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.msg.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.query.msg.CommonPublishedMessagePageQueryVO;
import com.elitesland.scp.application.facade.vo.resp.msg.BaseScpMessageListRespVO;
import com.elitesland.scp.application.facade.vo.resp.msg.CommonPublishedScpMessagePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.msg.CommonPublishedScpMessageRespVO;
import com.elitesland.scp.common.ScpMessageReceiverType;
import com.elitesland.scp.domain.convert.msg.ScpMessageConvert;
import com.elitesland.scp.domain.entity.msg.ScpMessageDO;
import com.elitesland.scp.domain.service.msg.ScpMessageQueryService;
import com.elitesland.scp.domain.service.msg.impl.BaseScpMessageService;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ScpMessageQueryServiceImpl
extends BaseScpMessageService
implements ScpMessageQueryService {
    private static final Logger logger = LoggerFactory.getLogger(ScpMessageQueryServiceImpl.class);

    @Override
    public ApiResult<Long> countUnView(ScpMessageReceiverType receiverType, String receiverId) {
        if (receiverType == null || CharSequenceUtil.isBlank((CharSequence)receiverId)) {
            return ApiResult.fail((String)"\u63a5\u6536\u4eba\u4e3a\u7a7a");
        }
        Long count = this.receiverRepoProc.countUnView(receiverType.name(), receiverId);
        return ApiResult.ok((Object)count);
    }

    @Override
    public ApiResult<PagingVO<CommonPublishedScpMessagePageRespVO>> pagePublished(ScpMessageReceiverType receiverType, CommonPublishedMessagePageQueryVO queryVO) {
        if (receiverType == null || CharSequenceUtil.isBlank((CharSequence)queryVO.getReceiverId())) {
            return ApiResult.fail((String)"\u63a5\u6536\u4eba\u4e3a\u7a7a");
        }
        PagingVO<CommonPublishedScpMessagePageRespVO> pageData = this.pageQuery(receiverType, queryVO);
        return ApiResult.ok(pageData);
    }

    @Override
    public ApiResult<CommonPublishedScpMessageRespVO> viewPublished(Long id, ScpMessageReceiverType receiverType, String receiverId) {
        Assert.notNull((Object)id, (String)"\u6d88\u606fID\u4e3a\u7a7a", (Object[])new Object[0]);
        CommonPublishedScpMessageRespVO message = this.getMessage(id);
        if (receiverType != null && StringUtils.hasText((String)receiverId)) {
            this.taskExecutor.execute(() -> this.receiverRepoProc.updateViewed(id, receiverType.name(), receiverId));
        }
        return ApiResult.ok((Object)message);
    }

    private PagingVO<CommonPublishedScpMessagePageRespVO> pageQuery(ScpMessageReceiverType receiverType, CommonPublishedMessagePageQueryVO queryVO) {
        PagingVO pageData = this.repoProc.pagePublished(receiverType.name(), queryVO).map(ScpMessageConvert.INSTANCE::convert2PublishedPageVO);
        if (pageData.isEmpty()) {
            return pageData;
        }
        super.fillListInfo(pageData.getRecords());
        Set<Long> ids = pageData.stream().map(BaseScpMessageListRespVO::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Long, Boolean> viewedMap = this.receiverRepoProc.queryViewed(ids, receiverType.name(), queryVO.getReceiverId());
        pageData.each(t -> t.setViewed(viewedMap.getOrDefault(t.getId(), false)));
        return pageData;
    }

    private CommonPublishedScpMessageRespVO getMessage(long id) {
        ScpMessageDO messageDO = (ScpMessageDO)((Object)this.repoProc.get(id));
        if (messageDO == null || Boolean.FALSE.equals(messageDO.getPublished()) || messageDO.getPublishTime().isAfter(LocalDateTime.now())) {
            return null;
        }
        CommonPublishedScpMessageRespVO noticeVO = ScpMessageConvert.INSTANCE.convert2PublishedVO(messageDO);
        super.fillDetailInfo(messageDO, noticeVO);
        return noticeVO;
    }
}

