package com.elitesland.scp.application.facade.vo.resp.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 06月 20日 17:26
 * @version: 1.0
 */
@Data
public class AppItemPriceRespVO implements Serializable {

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("销售单价（不含服务费）")
    private BigDecimal salePrice;

    @ApiModelProperty("仓配结算价")
    private BigDecimal costPrice;

    @ApiModelProperty("采购价")
    private BigDecimal purPrice;

    @ApiModelProperty("总价格")
    private BigDecimal price;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("科技费价格")
    private BigDecimal tefPrice;

    @ApiModelProperty("营销费价格")
    private BigDecimal mefPrice;

    @ApiModelProperty("运营费价格")
    private BigDecimal oefPrice;

    @ApiModelProperty("是否收取项目费用")
    private Boolean isProjFeeCharged;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuCode;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuCode;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuCode;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuName;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuName;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuName;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty(value = "组合数量")
    private BigDecimal combineQty;

}
