package com.elitesland.scp.application.service.mrp;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale2c.dto.Sale2cSoRpcDTO;
import com.elitesland.sale2c.param.Sale2cSoRpcParam;
import com.elitesland.sale2c.service.Sale2cSoRpcService;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseParam;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseRefParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseRefVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderDeleteParamVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderSaveParamVO;
import com.elitesland.scp.application.facade.vo.template.ScpDemandTemplateImportEntity;
import com.elitesland.scp.application.service.calendar.ScpStoreDemandCalendarService;
import com.elitesland.scp.application.service.template.DemandOrderTemplateService;
import com.elitesland.scp.domain.convert.mrp.ScpThousandUseConvert;
import com.elitesland.scp.domain.convert.mrp.ScpThousandUseRefConvert;
import com.elitesland.scp.domain.entity.mrp.ScpThousandUseDO;
import com.elitesland.scp.domain.entity.mrp.ScpThousandUseRefDO;
import com.elitesland.scp.infr.repo.mrp.ScpThousandUseRefRepo;
import com.elitesland.scp.infr.repo.mrp.ScpThousandUseRefRepoProc;
import com.elitesland.scp.infr.repo.mrp.ScpThousandUseRepo;
import com.elitesland.scp.infr.repo.mrp.ScpThousandUseRepoProc;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: wangly
 * @create: 2025-03-28
 * @Version 1.0
 **/
@RequiredArgsConstructor
@Service
@Slf4j
public class ScpThousandUseServiceImpl  implements ScpThousandUseService {

    private final ScpThousandUseRepo scpThousandUseRepo;
    private final ScpThousandUseRepoProc scpThousandUseRepoProc;
    private final ScpThousandUseRefRepo scpThousandUseRefRepo;
    private final ScpThousandUseRefRepoProc scpThousandUseRefRepoProc;
    private final ScpStoreDemandCalendarService scpStoreDemandCalendarService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiItemService rmiItemService;
    private final DemandOrderTemplateService deemandOrderTemplateService;
    private final Sale2cSoRpcService sale2cSoRpcService;
    @Override
    public PagingVO<ScpThousandUseVO> queryPaging(ScpThousandUseParam param){
        return scpThousandUseRepoProc.queryPaging(param);
    }

    @Override
    public List<ScpThousandUseVO> queryListDynamic(ScpThousandUseParam param){
        return scpThousandUseRepoProc.queryListDynamic(param);
    }

    @Override
    public ScpThousandUseVO queryByKey(Long key) {
        ScpThousandUseDO entity = scpThousandUseRepo.findById(key).orElseGet(ScpThousandUseDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ScpThousandUseVO vo = ScpThousandUseConvert.INSTANCE.toVo(entity);
        // 查询明细
        ScpThousandUseRefParam param = new ScpThousandUseRefParam();
        param.setMasId(key);
        List<ScpThousandUseRefVO> scpThousandUseRefVOS = scpThousandUseRefRepoProc.queryListDynamic(param);
        vo.setScpThousandUseRefVOList(scpThousandUseRefVOS);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long save(ScpThousandUseParam param) {
        if(CollectionUtils.isEmpty(param.getScpThousandUseRefParamList())){
            throw new BusinessException("商品不能为空");
        }
        Long id = null;
        // 新增
        if(param.getId()==null){
            ScpThousandUseDO entityDo = ScpThousandUseConvert.INSTANCE.toDo(param);
            ScpThousandUseDO save = scpThousandUseRepo.save(entityDo);
            id = save.getId();
            List<ScpThousandUseRefParam> scpThousandUseRefParamList = param.getScpThousandUseRefParamList();
            List<ScpThousandUseRefDO> scpThousandUseRefDOList = new ArrayList();
            scpThousandUseRefParamList.stream().forEach(p->{
                ScpThousandUseRefDO scpThousandUseRefDO = ScpThousandUseRefConvert.INSTANCE.toDo(p);
                scpThousandUseRefDO.setMasId(save.getId());
                scpThousandUseRefDOList.add(scpThousandUseRefDO);
            });
            scpThousandUseRefRepo.saveAll(scpThousandUseRefDOList);
        }else{
            id = param.getId();
            // 更新的时候基本信息不回更新 直接全删全查
            scpThousandUseRefRepoProc.deleteSoftByMasId(Collections.singletonList(param.getId()));
            List<ScpThousandUseRefParam> scpThousandUseRefParamList = param.getScpThousandUseRefParamList();
            List<ScpThousandUseRefDO> scpThousandUseRefDOList = new ArrayList();
            scpThousandUseRefParamList.stream().forEach(p->{
                ScpThousandUseRefDO scpThousandUseRefDO = ScpThousandUseRefConvert.INSTANCE.toDo(p);
                scpThousandUseRefDO.setMasId(param.getId());
                if(scpThousandUseRefDO.getAdjustThousNum()==null){
                    scpThousandUseRefDO.setAdjustThousNum(scpThousandUseRefDO.getEstimateThousNum());
                }
                scpThousandUseRefDOList.add(scpThousandUseRefDO);
            });
            scpThousandUseRefRepo.saveAll(scpThousandUseRefDOList);
        }
        if(param.getSubmitFlag()!=null && param.getSubmitFlag()){
            ScpThousandUseVO scpThousandUseVO = queryByKey(id);
            ScpThousandUseRefParam scpThousandUseRefParam = new ScpThousandUseRefParam();
            scpThousandUseRefParam.setMasId(id);
            List<ScpThousandUseRefVO> scpThousandUseRefVOS = scpThousandUseRefRepoProc.queryListDynamic(scpThousandUseRefParam);

            countAndCreatePreModel(Collections.singletonList(scpThousandUseVO),scpThousandUseRefVOS);
        }
        return id;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ScpThousandUseVO update(ScpThousandUseParam param) {
        ScpThousandUseDO entity = scpThousandUseRepo.findById(param.getId()).orElseGet(ScpThousandUseDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ScpThousandUseDO entityDo = ScpThousandUseConvert.INSTANCE.toDo(param);
        entity.copy(entityDo);
        return ScpThousandUseConvert.INSTANCE.toVo(scpThousandUseRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ScpThousandUseParam param) {
        ScpThousandUseDO entity = scpThousandUseRepo.findById(param.getId()).orElseGet(ScpThousandUseDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = scpThousandUseRepoProc.updateByKeyDynamic(param);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            scpThousandUseRepoProc.deleteSoft(keys);
            scpThousandUseRefRepoProc.deleteSoftByMasId(keys);
        }
    }

    @Override
    @Transactional
    public void count() {
        ScpThousandUseParam param = new ScpThousandUseParam();
        List<ScpThousandUseVO> scpThousandUseVOS = scpThousandUseRepoProc.queryListDynamic(param);
        if(CollectionUtils.isEmpty(scpThousandUseVOS)){
            throw new BusinessException("千元用量数据不能为空");
        }
        List<Long> idList = scpThousandUseVOS.stream().map(ScpThousandUseVO::getId).collect(Collectors.toList());
        ScpThousandUseRefParam refParam = new ScpThousandUseRefParam();
        refParam.setMasIdList(idList);
        List<ScpThousandUseRefVO> scpThousandUseRefVOS = scpThousandUseRefRepoProc.queryListDynamic(refParam);
        countAndCreatePreModel(scpThousandUseVOS,scpThousandUseRefVOS);
    }

    @Override
    public void checkData(ScpThousandUseParam param) {
        if(param.getValidDataStart()==null || param.getValidDataEnd()==null){
            throw new BusinessException("有效日期起止不能为空");
        }
        param.setCheckFlag(true);
        long count = scpThousandUseRepoProc.count(param);
        if(count>0){
            throw new BusinessException("已存在有效期内的门店");
        }
    }

    private void countAndCreatePreModel(List<ScpThousandUseVO> scpThousandUseVOS,List<ScpThousandUseRefVO> scpThousandUseRefVOS){
        List<Long> stWhIdList = scpThousandUseVOS.stream().map(ScpThousandUseVO::getStWhId).collect(Collectors.toList());
        final Map<Long, List<ScpThousandUseRefVO>> scpThousandUseRefVOMap = scpThousandUseRefVOS.stream().collect(Collectors.groupingBy(ScpThousandUseRefVO::getStWhId));
        // 查询门店信息
        List<String> storeCodes =
                scpThousandUseVOS.stream().map(ScpThousandUseVO::getStWhCode).distinct().collect(Collectors.toList());
        log.info("门店编码集合:{}", JSONUtil.toJsonStr(storeCodes));
        List<OrgStoreDetailRpcDTO> queryByStoreCodes = rmiOrgStoreRpcService.queryByStoreCodes(storeCodes);
        Map<String, OrgStoreDetailRpcDTO> storeMap =
                queryByStoreCodes.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode,Function.identity()));
        // 查询商品信息
        List<String> itemCodeList = scpThousandUseRefVOS.stream().map(ScpThousandUseRefVO::getItemCode).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
        itmItemRpcDtoParam.setItemCodes(itemCodeList);
        List<ItmItemRpcDTO> itemRpcDtoList = rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
        Map<String, ItmItemRpcDTO> itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));


        // 从今天开始获取30天前的日期
        LocalDate thirtyDate = LocalDate.now().minusMonths(1L).plusDays(1L);
        // 查询订货单金额
        Map<String, BigDecimal> storeReceiveAmtMap = queryStoreReceiveAmt(storeCodes,thirtyDate);

        // 查询门店日历
        ScpStoreDemandCalendarPageParamVO queryParam = new ScpStoreDemandCalendarPageParamVO();
        queryParam.setStartDate(thirtyDate);
        queryParam.setEndDate(LocalDate.now());
        queryParam.setStoreIdList(stWhIdList);
        PagingVO<ScpStoreDemandCalendarPageVO> scpStoreDemandCalendarPageVOPagingVO = scpStoreDemandCalendarService.searchPage(queryParam);
        log.info("门店日历集合:{}", JSONUtil.toJsonStr(scpStoreDemandCalendarPageVOPagingVO));
        // 门店系数map
        Map<Long,BigDecimal> storeCoefficientMap = new HashMap<>();
        if(!CollectionUtils.isEmpty(scpStoreDemandCalendarPageVOPagingVO.getRecords())){
            List<ScpStoreDemandCalendarPageVO> records = scpStoreDemandCalendarPageVOPagingVO.getRecords();
            records.stream().forEach(p->{
                long w = p.getDayDetails().stream().filter(s -> s.getWorkStatus().equals("W")).count();
                if(!CollectionUtils.isEmpty(storeReceiveAmtMap) && storeReceiveAmtMap.containsKey(p.getStoreCode())){
                    BigDecimal bigDecimal = storeReceiveAmtMap.get(p.getStoreCode());
                    BigDecimal coefficient = bigDecimal.divide(new BigDecimal(w),4,RoundingMode.HALF_UP).divide(new BigDecimal(1000),2,RoundingMode.HALF_UP);
                    storeCoefficientMap.put(p.getStoreId(),coefficient);
                }
            });
        }
        // 生成预测模版
        // 先将之前的模版删除
        List<Long> demandIdList = scpThousandUseVOS.stream().filter(p -> StringUtils.hasText(p.getExt1())).map(s -> Long.valueOf(s.getExt1())).collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(demandIdList)){
            DemandOrderDeleteParamVO demandOrderDeleteParamVO = new DemandOrderDeleteParamVO();
            demandOrderDeleteParamVO.setIds(demandIdList);
            deemandOrderTemplateService.delete(demandOrderDeleteParamVO);
        }
        // 新增 并将值重新赋值给千元用量数据
        scpThousandUseVOS.stream().forEach(p->{
            if(storeCoefficientMap.containsKey(p.getStWhId()) && scpThousandUseRefVOMap.containsKey(p.getStWhId())){
                //主数据
                BigDecimal coefficient = storeCoefficientMap.get(p.getStWhId());
                List<ScpThousandUseRefVO> scpThousandUseRefVOS1 = scpThousandUseRefVOMap.get(p.getStWhId());
                DemandOrderSaveParamVO  demandOrderSaveParamVO = new DemandOrderSaveParamVO();
                demandOrderSaveParamVO.setDemandTemName(p.getStWhName()+"订货");
                demandOrderSaveParamVO.setStartDate(p.getValidDataStart());
                demandOrderSaveParamVO.setEndDate(p.getValidDataEnd());
                demandOrderSaveParamVO.setType("0");
                demandOrderSaveParamVO.setDocType("MAIN");
                demandOrderSaveParamVO.setDemandTemStatus(1);
                demandOrderSaveParamVO.setDetailedTime("一,二,三,四,五,六,日");
                // 门店
                DemandOrderSaveParamVO.WhStZoObject whStZoObject = new DemandOrderSaveParamVO.WhStZoObject();
                OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = storeMap.get(p.getStWhCode());
                whStZoObject.setWhStZoCode(p.getStWhCode());
                whStZoObject.setWhStZoName(p.getStWhName());
                whStZoObject.setDetailedAddress(orgStoreDetailRpcDTO.getAddressRpcDTO().getDetailAddr());
                whStZoObject.setBelongOuCode(orgStoreDetailRpcDTO.getOuCode());
                whStZoObject.setBelongOuName(orgStoreDetailRpcDTO.getOuName());
                whStZoObject.setBelongOrgCode(orgStoreDetailRpcDTO.getPcode());
                whStZoObject.setBelongOrgName(orgStoreDetailRpcDTO.getPname());
                whStZoObject.setStoreType("DIRECTSALE");
                whStZoObject.setType(0);
                // 商品
                List<ScpThousandUseRefVO> scpThousandUseRefVOS2 = scpThousandUseRefVOMap.get(p.getStWhId());
                List<DemandOrderSaveParamVO.ItemObject> itemObjectList = new ArrayList<>();
                scpThousandUseRefVOS2.forEach(item->{

                    if(!itemRpcDTOMap.containsKey(item.getItemCode())){
                        return;
                    }
                    ItmItemRpcDTO itmItemRpcDTO = itemRpcDTOMap.get(item.getItemCode());
                    DemandOrderSaveParamVO.ItemObject itemObject = new DemandOrderSaveParamVO.ItemObject();
                    itemObject.setItemId(item.getItemId());
                    itemObject.setItemCode(item.getItemCode());
                    itemObject.setItemName(item.getItemName());
                    itemObject.setItemCateCode(itmItemRpcDTO.getItemCateCode());
                    itemObject.setItemCateName(itmItemRpcDTO.getItemCateFullName());
                    itemObject.setItemSpec(item.getItemAttr());
                    itemObject.setBasicUnitMeasure(itmItemRpcDTO.getUom());
                    itemObject.setBasicUnitMeasureName(itmItemRpcDTO.getUomName());
                    BigDecimal ratio = BigDecimal.ZERO;
                    if(itmItemRpcDTO.getUom2().equals(itmItemRpcDTO.getUom3())){
                        ratio = itmItemRpcDTO.getUomRatio3();
                    }else{
                        ratio = itmItemRpcDTO.getUomRatio4();
                    }
                    BigDecimal qty = coefficient.multiply(item.getAdjustThousNum()).setScale(0,RoundingMode.HALF_UP);
                    itemObject.setDemandQuantity(qty.multiply(ratio));
                    itemObject.setUom2(itmItemRpcDTO.getUom2());
                    itemObject.setUom2Name(itmItemRpcDTO.getUom2Name());
                    itemObject.setQty2(qty);
                    itemObject.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
                    itemObject.setUomRatio(ratio);
                    itemObjectList.add(itemObject);

                });
                demandOrderSaveParamVO.setItemObjects(itemObjectList);
                demandOrderSaveParamVO.setWhStZoObjects(Collections.singletonList(whStZoObject));
                Long save = deemandOrderTemplateService.save(demandOrderSaveParamVO);

                ScpThousandUseParam updateParam = new ScpThousandUseParam();
                updateParam.setId(p.getId());
                updateParam.setExt1(save.toString());
                updateByKeyDynamic(updateParam);
            }

        });
    }
    private Map<String, BigDecimal> queryStoreReceiveAmt(List<String> storeCodeList,LocalDate thireDate){
        Map<String, BigDecimal> storeReceiveAmtMap = new HashMap<>();
        Sale2cSoRpcParam param = new Sale2cSoRpcParam();
        param.setStoreCodeList(storeCodeList);
        param.setBusinessDateStart(thireDate.atStartOfDay());
        param.setBusinessDateEnd(LocalDate.now().atTime(LocalTime.MAX));
        param.setDocType("POST");
        List<Sale2cSoRpcDTO> sale2cSoByParamList = sale2cSoRpcService.findSale2cSoByParam(param).getData();
        log.info("查询的零货单为{}",JSONUtil.toJsonStr(sale2cSoByParamList));
        if(!CollectionUtils.isEmpty(sale2cSoByParamList)){
            storeReceiveAmtMap = sale2cSoByParamList.stream()
                    .filter(dto -> dto.getStoreCode() != null) // 过滤掉storeCode为null的情况
                    .collect(Collectors.toMap(
                            Sale2cSoRpcDTO::getStoreCode,
                            Sale2cSoRpcDTO::getReceivableAmt,
                            (amt1, amt2) -> amt1.add(amt2)
                    ));
        }
        return storeReceiveAmtMap;
    }
}