package com.elitesland.scp.application.web.purLimit;


import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingStoreSaveVO;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingStoreDomainService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@Api(tags = "订货强配门店接口")
@RestController
@RequestMapping(value = "/purLimit/setting/store", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpPurLimitSettingStoreController {

    private final ScpPurLimitSettingStoreDomainService scpPurLimitSettingStoreDomainService;

    @ApiOperation(value = "订货强配门店 -  门店分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpPurLimitSettingStoreRespVO>> queryPurLimitSettingStore(@RequestBody @Validated ScpPurLimitSettingStorePageParamVO paramVO) {
        log.info("[SCP-PurLimit-SETTING] queryPurLimitSettingStore  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpPurLimitSettingStoreDomainService.page(paramVO));
    }

    @PostMapping("/batchSave")
    @ApiOperation("订货强配门店 - 批量新增")
    public ApiResult<Long> batchSavePurLimitSettingStore(@RequestBody @Validated List<ScpPurLimitSettingStoreSaveVO> saveVOS) {
        log.info("[SCP-PurLimit-SETTING-STORE] batchSavePurLimitSettingStore  saveVO ={}", JSONUtil.toJsonStr(saveVOS));
        scpPurLimitSettingStoreDomainService.batchSavePurLimitSettingStore(saveVOS);
        return ApiResult.ok();
    }

    @PostMapping("/update")
    @ApiOperation("订货强配门店 - 修改")
    public ApiResult<Long> savePurLimitSettingStore(@RequestBody @Validated ScpPurLimitSettingStoreSaveVO saveVO) {
        log.info("[SCP-PurLimit-SETTING-STORE] savePurLimitSettingStore  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        scpPurLimitSettingStoreDomainService.updatePurLimitSettingStore(saveVO);
        return ApiResult.ok();
    }

    @ApiOperation("订货强配门店 - 删除")
    @PostMapping("/delete")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-PurLimit-SETTING-STORE] delete ids = {}", JSONUtil.toJsonStr(ids));
        scpPurLimitSettingStoreDomainService.deleteByIds(ids);
        return ApiResult.ok();
    }

}
