package com.elitesland.scp.infr.repo.minOrder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingStoreRespVO;
import com.elitesland.scp.domain.entity.minOrder.QScpMinOrderSettingDO;
import com.elitesland.scp.domain.entity.minOrder.QScpMinOrderSettingStoreDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpMinOrderSettingStoreRepoProc {
    private static final QScpMinOrderSettingStoreDO scpMinOrderSettingStoreDO = QScpMinOrderSettingStoreDO.scpMinOrderSettingStoreDO;
    private static final QScpMinOrderSettingDO scpMinOrderSettingDO = QScpMinOrderSettingDO.scpMinOrderSettingDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final QBean<ScpMinOrderSettingStoreRespVO> pageList = Projections.bean(
            ScpMinOrderSettingStoreRespVO.class,
            scpMinOrderSettingStoreDO.id,
            scpMinOrderSettingStoreDO.masId,
            scpMinOrderSettingStoreDO.storeId,
            scpMinOrderSettingStoreDO.storeCode,
            scpMinOrderSettingStoreDO.storeName,
            scpMinOrderSettingStoreDO.storeType2,
            scpMinOrderSettingStoreDO.maxNum

    );

    public long countMinOrderSettingStore(ScpMinOrderSettingStorePageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpMinOrderSettingStoreDO.count())
                .from(scpMinOrderSettingStoreDO);
        jpaQuery.where(this.whereMinOrderSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpMinOrderSettingStoreRespVO> queryMinOrderSettingStore(ScpMinOrderSettingStorePageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpMinOrderSettingStoreDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpMinOrderSettingStoreDO);
        jpaQuery.where(this.whereMinOrderSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereMinOrderSettingPage(ScpMinOrderSettingStorePageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (paramVO.getMasId() != null) {
            predicates.add(scpMinOrderSettingStoreDO.masId.eq(paramVO.getMasId()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<Long> findMasIdByStoreCode(String storeCode) {
        return jpaQueryFactory.select(scpMinOrderSettingStoreDO.masId).distinct()
                .from(scpMinOrderSettingStoreDO)
                .where(scpMinOrderSettingStoreDO.storeCode.eq(storeCode))
                .fetch();
    }

    public List<ScpMinOrderSettingStoreRespVO> findByParam(ScpMinOrderSettingStoreParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpMinOrderSettingStoreRespVO.class,
                        scpMinOrderSettingStoreDO.id,
                        scpMinOrderSettingStoreDO.masId,
                        scpMinOrderSettingStoreDO.storeId,
                        scpMinOrderSettingStoreDO.storeCode,
                        scpMinOrderSettingStoreDO.storeName,
                        scpMinOrderSettingStoreDO.storeType2,
                        scpMinOrderSettingStoreDO.maxNum,
                        scpMinOrderSettingStoreDO.activeNum
                ))
                .from(scpMinOrderSettingStoreDO);
        jpaQuery.where(scpMinOrderSettingStoreDO.masId.in(paramVO.getMasIds()));
        if (StrUtil.isNotBlank(paramVO.getStoreCode())) {
            jpaQuery.where(scpMinOrderSettingStoreDO.storeCode.eq(paramVO.getStoreCode()));
        }
        if (paramVO.getUsed() != null && paramVO.getUsed()) {
            jpaQuery.where(scpMinOrderSettingStoreDO.activeNum.gt(BigDecimal.ZERO));
        }
        return jpaQuery.fetch();
    }

    public List<ScpMinOrderSettingStoreRespVO> findEnabledByParam(ScpMinOrderSettingStoreParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpMinOrderSettingStoreRespVO.class,
                        scpMinOrderSettingStoreDO.id,
                        scpMinOrderSettingStoreDO.masId,
                        scpMinOrderSettingStoreDO.storeId,
                        scpMinOrderSettingStoreDO.storeCode,
                        scpMinOrderSettingStoreDO.storeName
                ))
                .from(scpMinOrderSettingStoreDO)
                .leftJoin(scpMinOrderSettingDO).on(scpMinOrderSettingStoreDO.masId.eq(scpMinOrderSettingDO.id));
        if (CollUtil.isNotEmpty(paramVO.getMasIds())) {
            jpaQuery.where(scpMinOrderSettingStoreDO.masId.in(paramVO.getMasIds()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreCodes())) {
            jpaQuery.where(scpMinOrderSettingStoreDO.storeCode.in(paramVO.getStoreCodes()));
        }
        jpaQuery.where(scpMinOrderSettingDO.status.eq(Boolean.TRUE));
        LocalDateTime startOfDay = LocalDateTime.now().toLocalDate().atStartOfDay();
        jpaQuery.where(scpMinOrderSettingDO.validTo.goe(startOfDay));
        return jpaQuery.fetch();
    }

    public List<Long> findUsedSettingByMasIds(List<Long> masIds) {
        var jpaQuery = jpaQueryFactory.select(scpMinOrderSettingStoreDO.masId).distinct()
                .from(scpMinOrderSettingStoreDO);
        jpaQuery.where(scpMinOrderSettingStoreDO.masId.in(masIds));
        jpaQuery.where(scpMinOrderSettingStoreDO.activeNum.gt(0));
        return jpaQuery.fetch();
    }
}
