/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreQueryParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreRespVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepo;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepoProc;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpStoreDemandCalendarDomainServiceImpl
implements ScpStoreDemandCalendarDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreDemandCalendarDomainServiceImpl.class);
    private final ScpStoreDemandCalendarRepoProc storeDemandCalendarRepoProc;
    private final ScpStoreDemandCalendarRepo scpStoreDemandCalendarRepo;
    private final EntityManager entityManager;

    @Override
    public PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO queryParam) {
        return this.storeDemandCalendarRepoProc.searchPage(queryParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(List<ScpStoreDemandCalendarDO> createList) {
        this.scpStoreDemandCalendarRepo.saveAll(createList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        this.scpStoreDemandCalendarRepo.deleteAllById(ids);
    }

    @Override
    public List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthKey(List<String> concatKey) {
        return this.scpStoreDemandCalendarRepo.findByConcatYearAndMonthKey(concatKey);
    }

    @Override
    public List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthAndDeliveryTypeKey(Collection<String> typeSet, Collection<String> storeCodeSet, Collection<String> yearSet, Collection<String> monthSet, Collection<String> deliverySet) {
        return this.storeDemandCalendarRepoProc.findByConcatYearAndMonthAndDeliveryTypeKey(typeSet, storeCodeSet, yearSet, monthSet, deliverySet);
    }

    @Override
    public List<ScpStoreDemandCalendarDO> findByStoreDayCalendar(List<String> concatKey) {
        return this.scpStoreDemandCalendarRepo.findByStoreDayCalendar(concatKey);
    }

    @Override
    public List<ScpStoreDemandCalendarDTO> listCalendarDTOs(ScpStoreDemandCalendarParam scpStoreDemandCalendarParam) {
        return this.storeDemandCalendarRepoProc.findDemandCalendarByParam(scpStoreDemandCalendarParam);
    }

    @Override
    public List<ScpStoreDemandCalendarDTO> findStoreCalendarByParam(ScpStoreDemandCalendarParamVO param) {
        return this.storeDemandCalendarRepoProc.findStoreCalendarByParam(param);
    }

    @Override
    public List<ScpCalendarStoreRespVO> listStoreByQueryParam(ScpCalendarStoreQueryParamVO param) {
        return this.storeDemandCalendarRepoProc.listStoreByQueryParam(param);
    }

    @Override
    public void batchInsert(List<ScpStoreDemandCalendarDO> createList, int batchSize) {
        int index = 0;
        for (ScpStoreDemandCalendarDO data : createList) {
            this.entityManager.persist((Object)data);
            if (batchSize <= 1 || ++index % batchSize != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (!createList.isEmpty()) {
            this.entityManager.flush();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByStoreAndYear(String type, List<String> storeCodes, String year) {
        this.storeDemandCalendarRepoProc.deleteByStoreAndYear(type, storeCodes, year);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByStoreAndYearAndDeliveryType(String type, List<String> storeCodes, String year, String deliveryType) {
        this.storeDemandCalendarRepoProc.deleteByStoreAndYearAndDeliveryType(type, storeCodes, year, deliveryType);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByStoreAndYearAndMonth(String type, List<String> storeCodes, String year, String month) {
        this.storeDemandCalendarRepoProc.deleteByStoreAndYearAndMonth(type, storeCodes, year, month);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByStoreAndYearAndMonthAndDeliveryType(String type, List<String> storeCodes, String year, String month, String deliveryType) {
        this.storeDemandCalendarRepoProc.deleteByStoreAndYearAndMonthAndDeliveryType(type, storeCodes, year, month, deliveryType);
    }

    @Override
    public Map<String, Boolean> isCanDelivery(String storeCode, String region, List<String> deliveryType) {
        LocalDate now = LocalDate.now();
        String year = String.valueOf(now.getYear());
        String month = String.format("%02d", now.getMonthValue());
        String day = String.valueOf(now.getDayOfMonth());
        return this.storeDemandCalendarRepoProc.isCanDelivery(storeCode, region, deliveryType, year, month, day);
    }

    public ScpStoreDemandCalendarDomainServiceImpl(ScpStoreDemandCalendarRepoProc storeDemandCalendarRepoProc, ScpStoreDemandCalendarRepo scpStoreDemandCalendarRepo, EntityManager entityManager) {
        this.storeDemandCalendarRepoProc = storeDemandCalendarRepoProc;
        this.scpStoreDemandCalendarRepo = scpStoreDemandCalendarRepo;
        this.entityManager = entityManager;
    }
}

