/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.pay.controller;

import com.elitesland.scp.pay.service.RefundsService;
import com.tenpay.business.entpay.mse.sdk.api.Refund;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/refund"})
public class RefundsController {
    private static final Logger log = LoggerFactory.getLogger(RefundsController.class);
    private final RefundsService refundsService;

    @PostMapping(value={"/create/{paymentId}"})
    public Refund create(@PathVariable(value="paymentId") String paymentId) throws EntpayException {
        log.info("\u9000\u6b3e\u7533\u8bf7\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paymentId);
        return this.refundsService.refundOrder(paymentId);
    }

    @GetMapping(value={"/retrieve/{refundId}"})
    public Refund retrieve(@PathVariable(value="refundId") String refundId) throws EntpayException {
        log.info("\u9000\u6b3e\u67e5\u8be2(\u5185\u5355\u53f7)\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)refundId);
        return Refund.retrieve((String)refundId);
    }

    @GetMapping(value={"/retrieve/out-refund-id/{outRefundId}"})
    public Refund retrieveByOutRefundId(@PathVariable(value="outRefundId") String outRefundId) throws EntpayException {
        log.info("\u9000\u6b3e\u67e5\u8be2(\u5916\u5355\u53f7)\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)outRefundId);
        return Refund.retrieveByOutRefundId((String)outRefundId);
    }

    public RefundsController(RefundsService refundsService) {
        this.refundsService = refundsService;
    }
}

