package com.elitesland.scp.application.service.stock;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invIo.InvIoDateRangeParamRpcDTO;
import com.elitesland.inv.dto.invIo.InvIoRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.dto.invwh.InvWhSimpleRpcDtoParam;
import com.elitesland.inv.provider.InvIoProvider;
import com.elitesland.inv.provider.InvStkProvider;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.scp.application.facade.vo.stock.*;
import com.elitesland.scp.application.facade.vo.stock.mq.ScpPredictStStockCalcSendParam;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.entity.stock.ScpPredictStStockCalcDO;
import com.elitesland.scp.domain.entity.stock.ScpPredictStStockDO;
import com.elitesland.scp.infr.dto.stock.ScpSafetyTargetStockDTO;
import com.elitesland.scp.infr.repo.stock.*;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-01-21
* @Version 1.0
**/
@RequiredArgsConstructor
@Service
@Slf4j
public class ScpPredictStStockCalcServiceImpl implements ScpPredictStStockCalcService {

    private final ScpPredictStStockCalcRepoProc scpPredictStStockCalcRepoProc;

    private final ScpPredictStStockCalcRepo scpPredictStStockCalcRepo;

    private final ScpPredictStStockRepoProc scpPredictStStockRepoProc;

    private final ScpPredictStStockRepo scpPredictStStockRepo;

    private final TaskExecutor executor;

    private final InvWhProvider invWhProvider;

    private final OrgOuRpcService orgOuRpcService;

    private final ItmItemRpcService itemRpcService;

    private final InvIoProvider invIoProvider;

    private final ScpSafetyTargetStockRepoProc scpSafetyTargetStockRepoProc;

    private final RmiSysUserRpcService rmiSysUserRpcService;

    private final UdcProvider udcProvider;







    @Override
    public PagingVO<ScpPredictStStockCalcPageVO> page(ScpPredictStStockCalcPageParam param) {
        if(CollectionUtils.isNotEmpty(param.getWhIds())){
            List<Long> stIds = scpPredictStStockRepoProc.findStIdsByWhIds(param.getWhIds());
            if(CollectionUtils.isEmpty(stIds)){
                return PagingVO.<ScpPredictStStockCalcPageVO>builder()
                        .total(0L)
                        .records(new ArrayList<>())
                        .build();
            }
            if(CollectionUtils.isEmpty(param.getStIds())){
                param.setStIds(stIds);
            }else{
                param.getStIds().addAll(stIds);
            }

        }
        if(CollectionUtils.isNotEmpty(param.getItemIds())){
            List<Long> stIds = scpPredictStStockRepoProc.findStIdsByItemIds(param.getItemIds());
            if(CollectionUtils.isEmpty(stIds)){
                return PagingVO.<ScpPredictStStockCalcPageVO>builder()
                        .total(0L)
                        .records(new ArrayList<>())
                        .build();
            }
            if(CollectionUtils.isEmpty(param.getStIds())){
                param.setStIds(stIds);
            }else{
                param.getStIds().addAll(stIds);
            }
        }
        PagingVO<ScpPredictStStockCalcPageVO> page = scpPredictStStockCalcRepoProc.page(param);
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            Map<String, String> stockStatusMap = udcProvider.getValueMapByUdcCode("yst-suplan", "ST_STOCK_STATUS");
            page.getRecords().forEach(d ->{
                d.setCalcuStatusName(stockStatusMap.get(d.getCalcuStatus()));
            });
        }
        return page;
    }

    @Override
    public PagingVO<ScpPredictStStockRespVO> stStockDetailPage(ScpPredictStStockParamVO param) {
        PagingVO<ScpPredictStStockRespVO> page = scpPredictStStockRepoProc.stStockDetailPage(param);
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            List<Long> itemIds = page.getRecords().stream()
                    .map(d -> d.getItemId()).distinct().collect(Collectors.toList());
            List<ItmItemSimpleRpcDTO> simpleItem = itemRpcService.findSimpleItem(itemIds);
            Map<Long, ItmItemSimpleRpcDTO> itemMap = simpleItem.stream().collect(Collectors.toMap(ItmItemSimpleRpcDTO::getId, v -> v, (e1, e2) -> e1));
            Map<String, String> uom = udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
            Integer qtyPlace = SysUtils.getQtyPlace();
            page.getRecords().forEach(d ->{
               if(itemMap.get(d.getItemId()) != null){
                   d.setItemName(itemMap.get(d.getItemId()).getItemName());
                   Integer places = itemMap.get(d.getItemId()).getDecimalPlaces();
                   places = places == null ? qtyPlace : places ;
                   d.setSaleQty(d.getIoQty().divide(d.getUomRatio(), places, RoundingMode.HALF_UP));
               }else{
                   d.setSaleQty(d.getIoQty().divide(d.getUomRatio(), qtyPlace, RoundingMode.HALF_UP));
               }
               d.setPlanUomName(uom.get(d.getPlanUom()));
            });
        }
        return page;
    }

    @Override
    @Transactional
    public void delete(List<Long> ids) {
        scpPredictStStockCalcRepo.deleteAllById(ids);
        scpPredictStStockRepo.deleteAllByStIdIn(ids);
    }

    @Override
    @Transactional
    public String calcPredictStStock(ScpPredictStStockCalcParamVO param) {
        if(CollectionUtils.isEmpty(param.getOuIds())){
            throw new BusinessException(ApiCode.FAIL,"计算前，先选择公司");
        }
        InvWhSimpleRpcDtoParam simpleRpcDtoParam = new InvWhSimpleRpcDtoParam();
        simpleRpcDtoParam.setOuIds(param.getOuIds());
        List<InvWhRpcSimpleDTO> whRpcSimpleDTOList = invWhProvider.findNonStoreWhRpcDTO(simpleRpcDtoParam).computeData();
        if(CollectionUtils.isEmpty(whRpcSimpleDTOList)){
            throw new BusinessException(ApiCode.FAIL,"未查询到公司下非门店仓类型仓库，请检查");
        }
        List<OrgOuRpcSimpleDTO> simpleOuDto = orgOuRpcService.findSimpleOuDto(param.getOuIds());
        if(CollectionUtils.isEmpty(simpleOuDto)){
            throw new BusinessException(ApiCode.FAIL,"未查询到公司信息，请检查");
        }
        List<Long> whOuIds = whRpcSimpleDTOList.stream().map(InvWhRpcSimpleDTO::getOuId).distinct().collect(Collectors.toList());
        List<OrgOuRpcSimpleDTO> ouRpcSimpleDTOS = simpleOuDto.stream().filter(d -> whOuIds.contains(d.getId())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(ouRpcSimpleDTOS)){
            throw new BusinessException(ApiCode.FAIL,"未查询到公司下非门店仓类型仓库对应的公司信息，请检查");
        }
        Map<Long, List<InvWhRpcSimpleDTO>> ouWhMap = whRpcSimpleDTOList.stream()
                .collect(Collectors.groupingBy(InvWhRpcSimpleDTO::getOuId));
        Map<Long, OrgOuRpcSimpleDTO> ouMap = ouRpcSimpleDTOS.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getId, v -> v));
        List<String> ouCodes = ouRpcSimpleDTOS.stream()
                .filter(d -> whOuIds.contains(d.getId()))
                .map(OrgOuRpcSimpleDTO::getOuCode).distinct().collect(Collectors.toList());
        if(CollectionUtils.isEmpty(ouCodes)){
            throw new BusinessException(ApiCode.FAIL,"没有符合非门店仓类型仓库的公司，请先配置");
        }
        ItmItemBusinessRpcDtoParam businessRpcDtoParam = new ItmItemBusinessRpcDtoParam();
        businessRpcDtoParam.setBuCodes(ouCodes);
        businessRpcDtoParam.setMrpType("PD");
        List<ItmItemBusinessRpcDTO> businessRpcDTOList = itemRpcService.findItmItemBusinessByParam(businessRpcDtoParam);
        if(CollectionUtils.isEmpty(businessRpcDTOList)){
            log.info("没有符合公司运行MRP类型经营目录商品数据，请先创建商品");
            throw new BusinessException(ApiCode.FAIL,"没有符合公司运行MRP类型经营目录商品数据，请先创建商品");
        }
        Map<String, List<ItmItemBusinessRpcDTO>> businessItemMap = businessRpcDTOList.stream().collect(Collectors.groupingBy(ItmItemBusinessRpcDTO::getBuCode));
        String lotNo = rmiSysUserRpcService
                .sysNumberRuleGenerateCode(ScpConstant.MRP_STOCK, new ArrayList<>());
        List<ScpPredictStStockCalcDO> scpPredictStStockCalcDOS = extractedStStockPredict(param, ouMap, ouWhMap,lotNo);
        Map<String, ScpPredictStStockCalcDO> map = scpPredictStStockCalcDOS.stream()
                .collect(Collectors.toMap(d -> d.getOuId().toString() + d.getPredLotNo(), d -> d));
        List<Long> ouIds = param.getOuIds().stream().filter(whOuIds::contains).distinct().collect(Collectors.toList());
        LocalDateTime dateTime = LocalDateTime.now();
        List<ScpStStockSyncParamVO> stockSyncParamVOS = new ArrayList<>();
        ouIds.forEach(d -> {
            ScpStStockSyncParamVO scpStStockSyncParamVO = new ScpStStockSyncParamVO();
            scpStStockSyncParamVO.setOuId(d);
            if(map.get(d + lotNo) !=null){
                scpStStockSyncParamVO.setStId(map.get(d + lotNo).getId());
                scpStStockSyncParamVO.setDateTime(dateTime);
                stockSyncParamVOS.add(scpStStockSyncParamVO);
            }
        });
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                ScpPredictStStockCalcSendParam sendParam = ScpPredictStStockCalcSendParam.build(stockSyncParamVOS);
                log.info("预测安全库存&目标库存 mq 消息开始：" + JSON.toJSONString(sendParam));
                ScpPredictStockSendUtil.send(sendParam,ScpPredictStockSendUtil.PREDICT_STOCK_CHANNEL);
                log.info("预测安全库存&目标库存 mq 消息成功：" + JSON.toJSONString(sendParam));

            }
        });
        return lotNo;
    }

    @Override
    @Transactional
    public void calcuStStock(List<ScpStStockSyncParamVO> stockSyncParamVOS) {
        //按产品要求默认30天
        LocalDate datetime= stockSyncParamVOS.get(0).getDateTime().toLocalDate();
        LocalDate minusMonthsDate = datetime.minusDays(30L);
//        long days = ChronoUnit.DAYS.between(minusMonthsDate.toLocalDate(), datetime.toLocalDate());
        long days = 30L;
        log.info("开始计算预测目标库存安全库存计算条件,开始时间：{},结束时间：{}",datetime,minusMonthsDate);
        List<Long> ouIds = stockSyncParamVOS.stream().map(ScpStStockSyncParamVO::getOuId).distinct().collect(Collectors.toList());
        List<Long> masIds = stockSyncParamVOS.stream().map(ScpStStockSyncParamVO::getStId).distinct().collect(Collectors.toList());
        List<ScpPredictStStockCalcDO> stStockCalcDOList = scpPredictStStockCalcRepo.findAllById(masIds);
        if(CollectionUtils.isEmpty(stStockCalcDOList)){
            log.error("预测目标库存安全库存计算条件异常，请检查");
            return;
        }
        Map<Long, ScpPredictStStockCalcDO> calcMap = stStockCalcDOList.stream().collect(Collectors.toMap(ScpPredictStStockCalcDO::getId, d -> d));
        if(ouIds.size() !=stockSyncParamVOS.size() ){
            ScpStStockCalcUpdateParam calcUpdateParam = new ScpStStockCalcUpdateParam();
            calcUpdateParam.setCalcuStatus("FAIL");
            calcUpdateParam.setStIds(stockSyncParamVOS.stream().map(ScpStStockSyncParamVO::getStId)
                    .collect(Collectors.toList()));
            calcUpdateParam.setCalcuMsg("数据异常，公司重复计算，请检查");
            scpPredictStStockCalcRepoProc.updateStStockCalcStatus(calcUpdateParam);
            return;
        }
        InvWhSimpleRpcDtoParam simpleRpcDtoParam = new InvWhSimpleRpcDtoParam();
        simpleRpcDtoParam.setOuIds(ouIds);
        List<InvWhRpcSimpleDTO> whRpcSimpleDTOList = invWhProvider.findNonStoreWhRpcDTO(simpleRpcDtoParam).computeData();
        List<OrgOuRpcSimpleDTO> simpleOuDto = orgOuRpcService.findSimpleOuDto(ouIds);
        Map<Long, List<InvWhRpcSimpleDTO>> ouWhMap = whRpcSimpleDTOList.stream()
                .collect(Collectors.groupingBy(InvWhRpcSimpleDTO::getOuId));
        Map<Long, OrgOuRpcSimpleDTO> ouMap = simpleOuDto.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getId, v -> v));
        List<String> ouCodes = simpleOuDto.stream().map(OrgOuRpcSimpleDTO::getOuCode).collect(Collectors.toList());
        ItmItemBusinessRpcDtoParam businessRpcDtoParam = new ItmItemBusinessRpcDtoParam();
        businessRpcDtoParam.setBuCodes(ouCodes);
        businessRpcDtoParam.setMrpType("PD");
        List<ItmItemBusinessRpcDTO> businessRpcDTOList = itemRpcService.findItmItemBusinessByParam(businessRpcDtoParam);
        Map<String, List<ItmItemBusinessRpcDTO>> businessItemMap = businessRpcDTOList.stream().collect(Collectors.groupingBy(ItmItemBusinessRpcDTO::getBuCode));
        int size = stockSyncParamVOS.size();
        List<ScpStStockCalcUpdateParam> stockCalcUpdateParams = new ArrayList<>();
        CompletableFuture<Void>[] futures = new CompletableFuture[size];
        ScpStStockCalcUpdateParam calcUpdateParam2 = new ScpStStockCalcUpdateParam();
        List<ScpPredictStStockDO> stockCalcDOs2 = new ArrayList<>();
        List<ScpPredictStStockDO> stockCalcDOs = new ArrayList<>();
        for (int i = 0; i < size; i++) {
            ScpStStockCalcUpdateParam calcUpdateParam = new ScpStStockCalcUpdateParam();
            calcUpdateParam.setCalcuStatus("DONE");
            calcUpdateParam.setCalcuMsg(null);
            ScpStStockSyncParamVO scpStStockSyncParamVO = stockSyncParamVOS.get(i);
            Long ouId = scpStStockSyncParamVO.getOuId();
            Long stId = scpStStockSyncParamVO.getStId();
            calcUpdateParam.setStIds(List.of(scpStStockSyncParamVO.getStId()));
            List<InvWhRpcSimpleDTO> whRpcSimpleDTOS = ouWhMap.get(ouId);
            if(CollectionUtils.isEmpty(whRpcSimpleDTOS)){
                calcUpdateParam.setCalcuStatus("FAIL");
                calcUpdateParam.setStIds(List.of(stId));
                calcUpdateParam.setCalcuMsg(String.format("未查询到公司【%s】下非门店仓类型仓库", ouId));
                stockCalcUpdateParams.add(calcUpdateParam);
                log.error(String.format("未查询到公司【%s】下非门店仓类型仓库", ouId));
                continue;
            }
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(ouId);
            List<ItmItemBusinessRpcDTO> itemBusinessRpcDTOS = businessItemMap.get(ouRpcSimpleDTO.getOuCode());
            if(CollectionUtils.isEmpty(itemBusinessRpcDTOS)){
                calcUpdateParam.setCalcuStatus("FAIL");
                calcUpdateParam.setStIds(List.of(stId));
                calcUpdateParam.setCalcuMsg(String.format("未查询到公司【%s】下符合MRP类型经营目录商品", ouId));
                stockCalcUpdateParams.add(calcUpdateParam);
                log.error(String.format("未查询到公司【%s】下符合MRP类型经营目录商品", ouId));
                continue;
            }
            try{
                Map<Long, InvWhRpcSimpleDTO> whMap = whRpcSimpleDTOS.stream().collect(Collectors.toMap(InvWhRpcSimpleDTO::getWhId, d -> d));
                List<Long> whIds = whRpcSimpleDTOS.stream().map(InvWhRpcSimpleDTO::getWhId).distinct().collect(Collectors.toList());
                List<Long> itemIds = itemBusinessRpcDTOS.stream().map(ItmItemBusinessRpcDTO::getId).distinct().collect(Collectors.toList());
                InvIoDateRangeParamRpcDTO rangeParamRpcDTO = new InvIoDateRangeParamRpcDTO();
                rangeParamRpcDTO.setItemIds(itemIds);
                rangeParamRpcDTO.setWhIds(whIds);
                rangeParamRpcDTO.setOuId(ouId);
                rangeParamRpcDTO.setIoDateFrom(minusMonthsDate.atTime(LocalTime.of(00, 00,00)));
                rangeParamRpcDTO.setIoDateTo(datetime.atTime(LocalTime.of(23, 59,59)));
                rangeParamRpcDTO.setSceneCodes(List.of("SO_OUT",
                        "SO_LOGIC_DELIVERY","SO_LOGIC_RECEIPT",
                        "SO_RETURN",
                        "TRN003",
                        "TRN_RELEASE_ISSUE",
                        "TRN008",
                        "TRN007",
                        "TRN004"));
                log.info("计算预测目标库存安全库存计算条件库存流水，参数：{}", JSON.toJSONString(rangeParamRpcDTO));
                List<InvIoRpcDTO> invIoRpcDTOS = invIoProvider.findInvIoByDateRange(rangeParamRpcDTO).computeData();
                Map<Long, List<InvIoRpcDTO>> whIoMap;
                if(CollectionUtils.isNotEmpty(invIoRpcDTOS)){
                    whIoMap = invIoRpcDTOS.stream().collect(Collectors.groupingBy(InvIoRpcDTO::getWhId));
                }else{
                    whIoMap = new HashMap<>();
                }

                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    for(Long whId:whIds){
                        List<InvIoRpcDTO> itemIoList = whIoMap.get(whId);
                        if(CollectionUtils.isEmpty(itemIoList)){
                            extractedStStockDo(whId, itemBusinessRpcDTOS, ouId,
                                    ouRpcSimpleDTO, whMap, stockCalcDOs2,stId,calcMap);
                        }else{
                            extractedStStock2(whId, itemIoList, itemBusinessRpcDTOS, ouId, ouRpcSimpleDTO,
                                    whMap, stockCalcDOs, days,stId,calcMap);
                        }
                    }
                }, executor);
                stockCalcUpdateParams.add(calcUpdateParam);
                futures[i] = future;
            }catch (Exception e){
                log.error("计算预测目标库存安全库存计算条件失败，" + ExceptionUtils.getStackTrace(e));
                calcUpdateParam.setCalcuStatus("FAIL");
                calcUpdateParam.setStIds(List.of(stId));
                calcUpdateParam.setCalcuMsg(ExceptionUtils.getStackTrace(e));
                stockCalcUpdateParams.add(calcUpdateParam);
            }
        }
        try {
            CompletableFuture.allOf(futures).get();
            if(CollectionUtils.isNotEmpty(stockCalcDOs2)){
                List<Long> stIds = stockCalcDOs2.stream()
                        .map(ScpPredictStStockDO::getStId)
                        .distinct().collect(Collectors.toList());
                List<String> businessIds = stockCalcDOs2.stream()
                        .map(ScpPredictStStockDO::getBusinessId)
                        .distinct().collect(Collectors.toList());
                scpPredictStStockRepoProc.deleteAllByBusinessIdAndStId(businessIds,stIds);
                List<ScpPredictStStockDO> distinctStockCalcDOs = new ArrayList<>(stockCalcDOs2.stream()
                        .collect(Collectors.toMap(
                                ScpPredictStStockDO::getBusinessId,
                                stock -> stock,
                                (existing, replacement) -> existing
                        ))
                        .values());
                distinctStockCalcDOs.forEach(d ->{});
                scpPredictStStockRepo.saveAll(distinctStockCalcDOs);
            }
            if(CollectionUtils.isNotEmpty(stockCalcDOs)){
                List<Long> stIds = stockCalcDOs.stream()
                        .map(ScpPredictStStockDO::getStId)
                        .distinct().collect(Collectors.toList());
                List<String> businessIds = stockCalcDOs.stream().map(ScpPredictStStockDO::getBusinessId).distinct().collect(Collectors.toList());
                scpPredictStStockRepoProc.deleteAllByBusinessIdAndStId(businessIds,stIds);
                List<ScpPredictStStockDO> distinctStockCalcDOs = new ArrayList<>(stockCalcDOs.stream()
                        .collect(Collectors.toMap(
                                ScpPredictStStockDO::getBusinessId,
                                stock -> stock,
                                (existing, replacement) -> existing
                        ))
                        .values());
                scpPredictStStockRepo.saveAll(distinctStockCalcDOs);
            }
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            calcUpdateParam2.setCalcuMsg("计算预测目标库存安全库存计算条件失败，线程被中断");
            log.error("计算预测目标库存安全库存计算条件失败，线程被中断", e);
            throw new BusinessException("计算预测目标库存安全库存计算条件失败，线程被中断", e);
        } catch (Exception e) {
            calcUpdateParam2.setCalcuMsg(e.getMessage());
            log.error("计算预测目标库存安全库存计算条件失败错误日志，" + ExceptionUtils.getStackTrace(e));
            throw new BusinessException("计算预测目标库存安全库存计算条件失败，" + e.getMessage(), e);
        } finally {
            if(CollectionUtils.isNotEmpty(stockCalcUpdateParams)){
                log.info("stockCalcUpdateParams is:{}",JSON.toJSONString(stockCalcUpdateParams));
                scpPredictStStockCalcRepoProc.updateBatchCalcStatus(stockCalcUpdateParams);
            }else{
                calcUpdateParam2.setCalcuStatus("FAIL");
                calcUpdateParam2.setStIds(stockSyncParamVOS.stream().map(ScpStStockSyncParamVO::getStId)
                        .collect(Collectors.toList()));
                scpPredictStStockCalcRepoProc.updateStStockCalcStatus(calcUpdateParam2);
            }
        }
    }

    @Override
    public List<ScpPredictStStockDownloadVO> downloadTmplFile(ScpPredictStStockDownLoadParam param) {
        if(param.getStId() == null || StringUtils.isEmpty(param.getPredLotNo())){
            throw new BusinessException(ApiCode.FAIL,"预测批次ID和预测批次不能为空");
        }
        if(param.getSize() ==null || param.getSize() == 10){
            param.setSize(20000);
        }
        PagingVO<ScpPredictStStockDownloadVO> pagingVO = scpPredictStStockRepoProc.findDownloadPredictStStock(param);
        if(CollectionUtils.isEmpty(pagingVO.getRecords())){
            return new ArrayList<>();
        }
        Map<String, String> uomMap = udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        List<Long> itemIds = pagingVO.getRecords().stream().map(ScpPredictStStockDownloadVO::getItemId).distinct().collect(Collectors.toList());
        List<ItmItemSimpleRpcDTO> simpleItem = itemRpcService.findSimpleItem(itemIds);
        Map<Long, ItmItemSimpleRpcDTO> itmItemMap = simpleItem.stream().collect(Collectors.toMap(ItmItemSimpleRpcDTO::getId, v -> v));
        pagingVO.getRecords().forEach(d ->{
            d.setStIdStr(d.getStId().toString());
            d.setPlanUomName(uomMap.get(d.getPlanUom()));
            if(itmItemMap.get(d.getItemId()) != null){
                d.setItemName(itmItemMap.get(d.getItemId()).getItemName());
            }
        });
        return pagingVO.getRecords();
    }

    private List<ScpPredictStStockCalcDO> extractedStStockPredict(ScpPredictStStockCalcParamVO param, Map<Long, OrgOuRpcSimpleDTO> ouMap,
                                         Map<Long, List<InvWhRpcSimpleDTO>> ouWhMap,String lotNo) {
        List<ScpPredictStStockCalcDO> scpPredictStStockCalcDOs = new ArrayList<>();
        param.getOuIds().forEach(d ->{
            ScpPredictStStockCalcDO scpPredictStStockCalcDO = new ScpPredictStStockCalcDO();
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(d);
            if(ouRpcSimpleDTO == null){
                scpPredictStStockCalcDO.setCalcuStatus("FAIL");
                scpPredictStStockCalcDO.setCalcuMsg(String.format("未查询到公司【%s】，数据不存在",ouRpcSimpleDTO.getOuName()));
            }
            scpPredictStStockCalcDO.setCreateTime(LocalDateTime.now());
            scpPredictStStockCalcDO.setOuId(d);
            scpPredictStStockCalcDO.setOuCode(ouRpcSimpleDTO.getOuCode());
            scpPredictStStockCalcDO.setOuName(ouRpcSimpleDTO.getOuName());
            scpPredictStStockCalcDO.setPredLotNo(lotNo);
            List<InvWhRpcSimpleDTO> whRpcSimpleDTOS = ouWhMap.get(d);
            if(CollectionUtils.isEmpty(whRpcSimpleDTOS)){
                scpPredictStStockCalcDO.setCalcuStatus("FAIL");
                scpPredictStStockCalcDO.setCalcuMsg(String.format("未查询公司【%s】下非门店仓类型仓库，请配置",ouRpcSimpleDTO.getOuName()));
            }else{
                scpPredictStStockCalcDO.setCalcuStatus("CALCUING");
            }
            scpPredictStStockCalcDOs.add(scpPredictStStockCalcDO);
        });
        long n1 = scpPredictStStockCalcDOs.stream().map(d -> d.getOuId().toString() + d.getPredLotNo())
                .distinct().count();

        if(scpPredictStStockCalcDOs.size() != n1){
            throw new BusinessException(ApiCode.FAIL,"公司预测批次不能重复,稍后重试");
        }
        return scpPredictStStockCalcRepo.saveAll(scpPredictStStockCalcDOs);

    }

    private void extractedStStock2(Long whId, List<InvIoRpcDTO> itemIoList,
                                   List<ItmItemBusinessRpcDTO> itemBusinessRpcDTOS, Long ouId,
                                   OrgOuRpcSimpleDTO ouRpcSimpleDTO, Map<Long, InvWhRpcSimpleDTO> whMap,
                                   List<ScpPredictStStockDO> stockCalcDOs, long days,Long stId,
                                   Map<Long, ScpPredictStStockCalcDO> calcMap) {
        Map<Long, List<InvIoRpcDTO>> listMap = itemIoList.stream().collect(Collectors.groupingBy(d -> d.getItemId()));
        for(ItmItemBusinessRpcDTO item: itemBusinessRpcDTOS){
            ScpPredictStStockDO stockCalcDO = new ScpPredictStStockDO();
            if(calcMap.get(stId) != null){
                stockCalcDO.setCreateUserId(calcMap.get(stId).getCreateUserId());
                stockCalcDO.setModifyUserId(calcMap.get(stId).getModifyUserId());
                stockCalcDO.setCreator(calcMap.get(stId).getCreator());
                stockCalcDO.setUpdater(calcMap.get(stId).getUpdater());
            }
            stockCalcDO.setStId(stId);
            stockCalcDO.setOuId(ouId);
            stockCalcDO.setOuCode(ouRpcSimpleDTO.getOuCode());
            stockCalcDO.setOuName(ouRpcSimpleDTO.getOuName());
            stockCalcDO.setItemId(item.getId());
            stockCalcDO.setItemCode(item.getItemCode());
            stockCalcDO.setItemCateCode(item.getItemCateCode());
            stockCalcDO.setBrand(item.getBrand());
            stockCalcDO.setWhId(whId);
            stockCalcDO.setWhCode(whMap.get(whId).getWhCode());
            stockCalcDO.setWhName(whMap.get(whId).getWhName());
            stockCalcDO.setPlanUom(item.getUom4());
            stockCalcDO.setBusinessId(ouId.toString() + whId.toString() +item.getId().toString());
            Integer purAheadPeriod = item.getPurAheadPeriod() == null ? 0 : item.getPurAheadPeriod();
            stockCalcDO.setPurAheadPeriod(purAheadPeriod);
            int recvDays = item.getRecvHandlerDays() == null ? 0 : item.getRecvHandlerDays();
            stockCalcDO.setRecvHandlerDays(recvDays);
            BigDecimal safeStockRatio = item.getSafeStockRatio() == null ? BigDecimal.ZERO : item.getSafeStockRatio();
            stockCalcDO.setSafeStockRatio(safeStockRatio);
            int purDelivPeriod = item.getPurDelivPeriod() == null ? 0 : item.getPurDelivPeriod();
            stockCalcDO.setPurDelivPeriod(purDelivPeriod);
            BigDecimal targetStockRatio = item.getTargetStockRatio() == null ? BigDecimal.ZERO : item.getTargetStockRatio();
            stockCalcDO.setTargetStockRatio(targetStockRatio);
            stockCalcDO.setUomRatio(item.getUomRatio4() == null ? BigDecimal.ONE: item.getUomRatio4());
            stockCalcDO.setDecimalPlaces(item.getDecimalPlaces() == null ? 4 : item.getDecimalPlaces());
            stockCalcDOs.add(stockCalcDO);
        }
        List<String> businessIds = stockCalcDOs.stream().map(d -> d.getBusinessId()).distinct().collect(Collectors.toList());
        List<ScpSafetyTargetStockDTO> safetyTargetStockDTOS = scpSafetyTargetStockRepoProc.findByBusinessIds(businessIds);
        Map<String, ScpSafetyTargetStockDTO> stockDTOMap =  CollectionUtils.isEmpty(safetyTargetStockDTOS) ? new HashMap<>() :
                safetyTargetStockDTOS.stream().collect(Collectors.toMap(d -> d.getBusinessId(), d -> d, (e1, e2) -> e1));
        for(ScpPredictStStockDO stockCalcDO: stockCalcDOs){
            ScpSafetyTargetStockDTO safetyTargetStockDTO = stockDTOMap.get(stockCalcDO.getBusinessId());
            List<InvIoRpcDTO> ioRpcDTOS = listMap.get(stockCalcDO.getItemId());
            if(CollectionUtils.isEmpty(ioRpcDTOS)){
                stockCalcDO.setPredTargetQty(BigDecimal.ZERO);
                stockCalcDO.setPredSafetyQty(BigDecimal.ZERO);
                if(safetyTargetStockDTO != null){
                    stockCalcDO.setSafetyQty(safetyTargetStockDTO.getSafetyQty());
                    stockCalcDO.setTargetQty(safetyTargetStockDTO.getTargetQty());
                    stockCalcDO.setPredTargetQty(stockCalcDO.getTargetQty());
                    stockCalcDO.setPredSafetyQty(stockCalcDO.getSafetyQty());
                }
            }else{
                if(safetyTargetStockDTO != null){
                    stockCalcDO.setSafetyQty(safetyTargetStockDTO.getSafetyQty());
                    stockCalcDO.setTargetQty(safetyTargetStockDTO.getTargetQty());
                }else{
                    stockCalcDO.setSafetyQty(BigDecimal.ZERO);
                    stockCalcDO.setTargetQty(BigDecimal.ZERO);
                }
                InvIoRpcDTO invIoRpcDTO = ioRpcDTOS.get(0);
                stockCalcDO.setIoQty(invIoRpcDTO.getSumQty().negate());
                BigDecimal qty = invIoRpcDTO.getSumQty()
                        .divide(stockCalcDO.getUomRatio(), stockCalcDO.getDecimalPlaces(), RoundingMode.HALF_UP);
                BigDecimal divide = qty
                        .divide(BigDecimal.valueOf(days),  stockCalcDO.getDecimalPlaces(), RoundingMode.HALF_UP);
                BigDecimal predSafetyQty = divide.multiply(BigDecimal.valueOf(stockCalcDO.getPurAheadPeriod() + stockCalcDO.getRecvHandlerDays()))
                        .multiply(stockCalcDO.getSafeStockRatio());
                stockCalcDO.setPredSafetyQty(predSafetyQty.setScale(0, RoundingMode.HALF_UP));
                BigDecimal targetQty = divide.multiply(BigDecimal.valueOf(stockCalcDO.getPurDelivPeriod()))
                        .multiply(stockCalcDO.getTargetStockRatio());
                stockCalcDO.setPredTargetQty(targetQty.setScale(0, RoundingMode.HALF_UP));
            }
        }
    }

    private void extractedStStockDo(Long whId, List<ItmItemBusinessRpcDTO> itemBusinessRpcDTOS,
                                    Long ouId, OrgOuRpcSimpleDTO ouRpcSimpleDTO,
                                    Map<Long, InvWhRpcSimpleDTO> whMap,
                                    List<ScpPredictStStockDO> stockCalcDOs2,Long stId,
                                    Map<Long, ScpPredictStStockCalcDO> calcMap) {
        for(ItmItemBusinessRpcDTO item: itemBusinessRpcDTOS){
            ScpPredictStStockDO stockCalcDO = new ScpPredictStStockDO();
            stockCalcDO.setStId(stId);
            stockCalcDO.setOuId(ouId);
            stockCalcDO.setOuCode(ouRpcSimpleDTO.getOuCode());
            stockCalcDO.setOuName(ouRpcSimpleDTO.getOuName());
            stockCalcDO.setItemId(item.getId());
            stockCalcDO.setItemCode(item.getItemCode());
            stockCalcDO.setItemCateCode(item.getItemCateCode());
            stockCalcDO.setBrand(item.getBrand());
            stockCalcDO.setWhId(whId);
            stockCalcDO.setWhCode(whMap.get(whId).getWhCode());
            stockCalcDO.setWhName(whMap.get(whId).getWhName());
            stockCalcDO.setPlanUom(item.getUom4());
            stockCalcDO.setUomRatio(item.getUomRatio4() == null ? BigDecimal.ONE: item.getUomRatio4());
            stockCalcDO.setDecimalPlaces(item.getDecimalPlaces() == null ? 4 : item.getDecimalPlaces());
            stockCalcDO.setBusinessId(ouId.toString() + whId.toString() +item.getId().toString());
            stockCalcDO.setIoQty(BigDecimal.ZERO);
            if(calcMap.get(stId) != null){
                stockCalcDO.setCreateUserId(calcMap.get(stId).getCreateUserId());
                stockCalcDO.setModifyUserId(calcMap.get(stId).getModifyUserId());
                stockCalcDO.setUpdater(calcMap.get(stId).getUpdater());
                stockCalcDO.setCreator(calcMap.get(stId).getCreator());
            }
            stockCalcDOs2.add(stockCalcDO);
        }
        List<String> keys = stockCalcDOs2.stream()
                .map(ScpPredictStStockDO::getBusinessId).distinct().collect(Collectors.toList());
        List<ScpSafetyTargetStockDTO> byBusinessIds = scpSafetyTargetStockRepoProc.findByBusinessIds(keys);
        Map<String, ScpSafetyTargetStockDTO> stockDTOMap =  CollectionUtils.isEmpty(byBusinessIds) ? new HashMap<>() :
                byBusinessIds.stream().collect(Collectors.toMap(d -> d.getBusinessId(), d -> d, (e1, e2) -> e1));
        for(ScpPredictStStockDO stockCalcDO: stockCalcDOs2){
            if(stockDTOMap.get(stockCalcDO.getBusinessId()) != null){
                stockCalcDO.setSafetyQty(stockDTOMap.get(stockCalcDO.getBusinessId()).getSafetyQty());
                stockCalcDO.setTargetQty(stockDTOMap.get(stockCalcDO.getBusinessId()).getTargetQty());
                stockCalcDO.setPlanUom(stockDTOMap.get(stockCalcDO.getBusinessId()).getPlanUom());
                stockCalcDO.setPredSafetyQty(stockCalcDO.getSafetyQty());
                stockCalcDO.setPredTargetQty(stockCalcDO.getTargetQty());
            }else{
                stockCalcDO.setSafetyQty(BigDecimal.ZERO);
                stockCalcDO.setTargetQty(BigDecimal.ZERO);
                stockCalcDO.setPredSafetyQty(BigDecimal.ZERO);
                stockCalcDO.setPredTargetQty(BigDecimal.ZERO);
            }
        }
    }
}