package com.elitesland.scp.application.web.app;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppInvStkRespVO;
import com.elitesland.scp.application.service.app.AppInvStkService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "移动端-库存查询接口")
@RestController
@RequestMapping(value = "/app/inv", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class AppInvStkController {

    private final AppInvStkService appInvStkService;

    @PostMapping("/list")
    @ApiOperation("库存 - 库存列表")
    public ApiResult<PagingVO<AppInvStkRespVO>> queryList(@RequestBody AppItemPageParamVO paramVO) {
        log.info("[APP-SCP-INV-STK] queryList  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(appInvStkService.page(paramVO));
    }
}
