package com.elitesland.scp.application.web.template;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.template.*;
import com.elitesland.scp.application.service.template.DemandOrderTemplateService;
import com.elitesland.scp.application.web.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/4/24 16:11
 * @Description:
 */
@Slf4j
@RestController
@RequestMapping(value = "/template", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
@Api(value = "订货模板", tags = {"订货模板"})
public class DemandOrderTemplateController extends BaseController {

    private final DemandOrderTemplateService deemandOrderTemplateService;

    @PostMapping(value = "/detail")
    @ApiOperation(value = "模板详情")
    public ApiResult<DemandOrderDetailRespVO> detail(@RequestBody @Validated DemandOrderDetailQueryVO demandOrderDetailQueryVO) {
        return ApiResult.ok(deemandOrderTemplateService.detail(demandOrderDetailQueryVO));
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存模板")
    public ApiResult<Long> save(@RequestBody DemandOrderSaveParamVO demandOrderSaveParamVO) {
        return ApiResult.ok(deemandOrderTemplateService.save(demandOrderSaveParamVO));
    }

    @PostMapping(value = "/page")
    @ApiOperation(value = "模板分页查询")
    public ApiResult<PagingVO<DemandOrderPageRespVO>> page(@RequestBody DemandOrderPageQueryVO demandOrderPageQueryVO) {
        return ApiResult.ok(deemandOrderTemplateService.page(demandOrderPageQueryVO));
    }

    @PostMapping(value = "/statusChange")
    @ApiOperation(value = "启用/禁用")
    public ApiResult<String> statusChange(@RequestBody @Validated DemandOrderStatusChangeParamVO demandOrderStatusChangeParamVO) {
        deemandOrderTemplateService.statusChange(demandOrderStatusChangeParamVO);
        return ApiResult.ok("ok");
    }

    @PostMapping(value = "/delete")
    @ApiOperation(value = "删除模板")
    public ApiResult<String> delete(@RequestBody @Validated DemandOrderDeleteParamVO demandOrderSaveParamVO) {
        deemandOrderTemplateService.delete(demandOrderSaveParamVO);
        return ApiResult.ok("ok");
    }

    @PostMapping(value = "/load")
    @ApiOperation(value = "载入模板")
    public ApiResult<PagingVO<DemandOrderPageRespVO>> load(@RequestBody @Validated DemandOrderLoadParamVO demandOrderLoadParamVO) {
        log.info("[SCP-DEMAND-TEMPLATE] load  param ={}", JSONUtil.toJsonStr(demandOrderLoadParamVO));
        return ApiResult.ok(deemandOrderTemplateService.load(demandOrderLoadParamVO));
    }


    @PostMapping(value = "/apply")
    @ApiOperation(value = "应用模板")
    public ApiResult<DemandOrderApplyRespVO> apply(@RequestBody @Validated DemandOrderApplyParamVO demandOrderApplyParamVO) {
        log.info("[SCP-DEMAND-TEMPLATE] apply  param ={}", JSONUtil.toJsonStr(demandOrderApplyParamVO));
        return ApiResult.ok(deemandOrderTemplateService.apply(demandOrderApplyParamVO));
    }

    //小程序接口
    @PostMapping(value = "/list")
    @ApiOperation(value = "小程序选择模板列表")
    public ApiResult<List<DemandOrderListRespVO>> list(@RequestBody @Validated DemandOrderListParamVO demandOrderListParamVO) {
        return ApiResult.ok(deemandOrderTemplateService.list(demandOrderListParamVO));
    }

    @PostMapping(value = "/applyCart")
    @ApiOperation(value = "小程序加载模板并添加采购车")
    public ApiResult<DemandOrderApplyRespVO> applyCart(@RequestBody @Validated DemandOrderApplyParamVO demandOrderApplyParamVO) {
        log.info("[SCP-DEMAND-TEMPLATE] applyCart  param ={}", JSONUtil.toJsonStr(demandOrderApplyParamVO));
        return ApiResult.ok(deemandOrderTemplateService.applyCart(demandOrderApplyParamVO));
    }
}
