package com.elitesland.scp.domain.entity.template;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;

/**
 * @Auther: Mark
 * @Date: 2024/4/24 16:08
 * @Description:
 */
@Data
@ApiModel(value = "scp_template_order_resp", description = "模板表单表")
public class ScpTemplateOrder extends BaseModel {
    private static final long serialVersionUID = 815011868646699454L;

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("类型")
    private Integer type;

    @ApiModelProperty("门店/仓库/区域id")
    private Long whStZoId;

    @ApiModelProperty("门店/仓库/区域编号")
    private String whStZoCode;

    @ApiModelProperty("门店/仓库/区域名称")
    private String whStZoName;

    @ApiModelProperty("详细地址")
    private String detailedAddress;

    @ApiModelProperty("所属组织编码")
    private String belongOrgCode;

    @ApiModelProperty("所属组织名称")
    private String belongOrgName;

    @ApiModelProperty("所属公司编码")
    private String belongOuCode;

    @ApiModelProperty("所属公司名称")
    private String belongOuName;

    @ApiModelProperty("经营性质")
    private String storeType;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品分类/品类")
    private String itemCateCode;

    @ApiModelProperty("商品分类/品类")
    private String itemCateName;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("基本计量单位")
    private String basicUnitMeasure;

    @ApiModelProperty("重量")
    private BigDecimal weight;

    @ApiModelProperty("重量单位")
    private String weightUom;

    @ApiModelProperty("重量单位名称")
    private String weightUomName;

    @ApiModelProperty("订货数量")
    private BigDecimal demandQuantity;

    @ApiModelProperty("总重量")
    private BigDecimal totalWeight;

    @ApiModelProperty("错误原因")
    private String errorReason;

}
