package com.elitesland.scp.mq;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayParamDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayParamDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderUpdatePayStatusMqParam;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@Component
@Slf4j
@RequiredArgsConstructor
public class ScpOrderUpdatePayStatusListener implements MessageQueueListener<ScpOrderUpdatePayStatusMqParam> {

    private final TransactionTemplate transactionTemplate;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{ScpOrderUpdatePayStatusMqParam.SCP_ORDER_UPDATE_PAY_STATUS_CHANNEL};
    }

    @Override
    public void onConsume(@NotBlank String s, @NotNull ScpOrderUpdatePayStatusMqParam param) {
        log.info("订单支付更新关联单据状态参数:{}", JSONUtil.toJsonStr(param));
        if ("PO".equals(param.getDocCls())) {
            PurPoOnlinePayParamDTO payParamDTO = new PurPoOnlinePayParamDTO();
            payParamDTO.setDocNo(param.getDocNo());
            payParamDTO.setOnlinePayAmt(param.getAmt());
            payParamDTO.setOnlinePayOrderNo(param.getPaymentId());
            rmiPurRpcService.updateOnlinePay(payParamDTO);
        } else {
            InvTroOnlinePayParamDTO payParamDTO = new InvTroOnlinePayParamDTO();
            payParamDTO.setDocNo(param.getDocNo());
            payParamDTO.setOnlinePayAmt(param.getAmt());
            payParamDTO.setOnlinePayOrderNo(param.getPaymentId());
            rmiInvStkRpcService.updateOnlinePay(payParamDTO);
        }
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionTemplate.execute(transactionStatus -> {
            try {
                scpDemandOrderDRepoProc.updateOnlinePayFlagAndPayerNameBySrcDocNo(param.getDocNo(), param.getPayerName(),
                        Boolean.TRUE);
                return "ok";
            } catch (Exception e) {
                log.error("更新订货单失败:{}", e.getMessage(), e);
                // 回滚
                transactionStatus.setRollbackOnly();
                return "ok";
            }
        });
    }
}
