/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.item;

import com.alibaba.excel.EasyExcel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemOperationAddParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemOperationParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemOperationVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemOperationVisibleParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPreSaleParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpItemSaleScopeImportParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpItemSaleScopeStoreImportVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpItemVisibleScopeImportParam;
import com.elitesland.scp.application.service.item.ScpCateItemService;
import com.elitesland.scp.utils.excel.ExcelEntityDataListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e2d\u53f0-\u62a5\u8d27\u5546\u54c1\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"/cate/item/operate"}, produces={"application/json"})
public class CateItemOperationController {
    private static final Logger log = LoggerFactory.getLogger(CateItemOperationController.class);
    private final ScpCateItemService scpCateItemService;

    @ApiOperation(value="\u62a5\u8d27\u5546\u54c1 - \u8bbe\u7f6e\u53ef\u552e\u8303\u56f4")
    @PostMapping(value={"/setSaleScope"})
    public ApiResult<?> setSaleScope(@RequestBody @Validated ScpCateItemOperationParam param) {
        try {
            this.scpCateItemService.setSaleScope(param);
            return ApiResult.ok();
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u53ef\u552e\u8303\u56f4\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u62a5\u8d27\u5546\u54c1 - \u5220\u9664\u53ef\u552e\u8303\u56f4")
    @PostMapping(value={"/deleteSaleScope"})
    public ApiResult<?> deleteSaleScope(@RequestBody @Validated ScpCateItemOperationAddParam param) {
        try {
            this.scpCateItemService.deleteSaleScope(param);
            return ApiResult.ok();
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u53ef\u552e\u8303\u56f4\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u62a5\u8d27\u5546\u54c1 - \u589e\u52a0\u53ef\u552e\u8303\u56f4")
    @PostMapping(value={"/addSaleScope"})
    public ApiResult<?> addSaleScope(@RequestBody @Validated ScpCateItemOperationAddParam param) {
        try {
            this.scpCateItemService.addSaleScope(param);
            return ApiResult.ok();
        }
        catch (Exception e) {
            log.error("\u589e\u52a0\u53ef\u552e\u8303\u56f4\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u62a5\u8d27\u5546\u54c1 - \u67e5\u770b\u53ef\u552e\u8303\u56f4\u95e8\u5e97")
    @GetMapping(value={"/getSaleScope/{id}"})
    public ApiResult<ScpCateItemOperationVO> getSaleScope(@PathVariable Long id) {
        ScpCateItemOperationVO saleScope = this.scpCateItemService.getSaleScope(id);
        return ApiResult.ok((Object)saleScope);
    }

    @ApiOperation(value="\u62a5\u8d27\u5546\u54c1 - \u8bbe\u7f6e\u53ef\u89c1\u8303\u56f4")
    @PostMapping(value={"/setVisibleScope"})
    public ApiResult<?> setVisibleScope(@RequestBody @Validated ScpCateItemOperationVisibleParam param) {
        try {
            this.scpCateItemService.setVisibleScope(param);
            return ApiResult.ok();
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u53ef\u89c1\u8303\u56f4\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u62a5\u8d27\u5546\u54c1 - \u67e5\u770b\u53ef\u89c1\u8303\u56f4\u95e8\u5e97")
    @GetMapping(value={"/getVisibleScope/{id}"})
    public ApiResult<ScpCateItemOperationVO> getVisibleScope(@PathVariable Long id) {
        ScpCateItemOperationVO saleScope = this.scpCateItemService.getVisibleScope(id);
        return ApiResult.ok((Object)saleScope);
    }

    @ApiOperation(value="\u62a5\u8d27\u5546\u54c1 - \u4fee\u6539\u9884\u552e\u72b6\u6001")
    @PostMapping(value={"/setPreSaleStatus"})
    public ApiResult<String> setPreSaleStatus(@RequestBody @Validated ScpCateItemPreSaleParam param) {
        return this.scpCateItemService.setPreSaleStatus(param);
    }

    @ApiOperation(value="\u62a5\u8d27\u5546\u54c1 - \u4fee\u6539\u4e0a\u4e0b\u67b6\u72b6\u6001")
    @PostMapping(value={"/setUpDownStatus"})
    public ApiResult<String> setUpDownStatus(@RequestBody @Validated ScpCateItemPreSaleParam param) {
        return this.scpCateItemService.setUpDownStatus(param);
    }

    @PostMapping(value={"/importSaleScope"})
    @ApiOperation(value="\u5546\u54c1\u53ef\u552e\u8303\u56f4-\u5bfc\u5165\u660e\u7ec6")
    public ApiResult<Object> importDetail(ScpItemSaleScopeImportParam param) {
        ExcelEntityDataListener dataListener = new ExcelEntityDataListener();
        try {
            EasyExcel.read((InputStream)param.getFile().getInputStream(), ScpItemSaleScopeStoreImportVO.class, dataListener).doReadAll();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        List<ScpItemSaleScopeStoreImportVO> list = dataListener.getDatas();
        return this.scpCateItemService.importSaleScope(list, param);
    }

    @PostMapping(value={"/importVisibleScope"})
    @ApiOperation(value="\u5546\u54c1\u53ef\u89c1\u8303\u56f4-\u5bfc\u5165\u660e\u7ec6")
    public ApiResult<Object> importVisibleScope(ScpItemVisibleScopeImportParam param) {
        ExcelEntityDataListener dataListener = new ExcelEntityDataListener();
        try {
            EasyExcel.read((InputStream)param.getFile().getInputStream(), ScpItemSaleScopeStoreImportVO.class, dataListener).doReadAll();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        List<ScpItemSaleScopeStoreImportVO> list = dataListener.getDatas();
        return this.scpCateItemService.importVisibleScope(list, param);
    }

    public CateItemOperationController(ScpCateItemService scpCateItemService) {
        this.scpCateItemService = scpCateItemService;
    }
}

