package com.elitesland.scp.application.facade.vo.param.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
@ApiModel(value = "商品价格查询入参")
public class AppItemActivityItemPriceParamVO implements Serializable {
    private static final long serialVersionUID = 5231978221986074352L;

    @ApiModelProperty(value = "商品ID", required = true)
    private Long itemId;

    @ApiModelProperty(value = "商品编码", required = true)
    private String itemCode;

    @ApiModelProperty(value = "商品单位", required = true)
    private String uom;

    @ApiModelProperty(value = "门店编码", required = true)
    private String storeCode;

    @ApiModelProperty(value = "类型", required = true)
    @NotBlank(message = "类型不能为空")
    private String type;

    @ApiModelProperty(value = "商品品类编码", required = true)
    private String itemCateCode;

    @ApiModelProperty(value = "配送类型", required = true)
    private String deliveryType;

    @ApiModelProperty(value = "配送类型", required = true)
    private String itemType2;

    @ApiModelProperty("是否收取项目费用")
    private Boolean whChargeFlag;

    @ApiModelProperty("是否收取项目费用")
    private Boolean deliveryChargeFlag;

    @ApiModelProperty(value = "仓网ID")
    private Long whNetId;

    @ApiModelProperty("是否匹配供应商")
    private Boolean suppMatch;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品Id")
    private String combineItemId;

    @ApiModelProperty(value = "强配活动编码")
    private String activityCode;

    /**
     * 甲指乙采 输入收货人地址
     *
     */
    @ApiModelProperty(value = "收货人地址")
    private AddressParamVO addressParam;
}

